/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;

public class CauchyDistribution
implements IDistribution {
    private double location;
    private double scale;
    private double lnconstant;
    private double constant;
    private boolean immutable;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double location, double scale) {
        if (scale < 0.0) {
            try {
                throw new IllegalArgumentException("Scale must be greater than zero.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.Init(location, scale);
    }

    private void Init(double location, double scale) {
        this.location = location;
        this.scale = scale;
        this.constant = 1.0 / (Math.PI * scale);
        this.lnconstant = -Math.log(Math.PI * scale);
    }

    public double getScale() {
        return this.scale;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double Mean() {
        return Double.NaN;
    }

    public double Median() {
        return this.location;
    }

    public double Mode() {
        return this.location;
    }

    @Override
    public double Variance() {
        return Double.NaN;
    }

    @Override
    public double Entropy() {
        return Math.log(this.scale) + Math.log(Math.PI * 4);
    }

    @Override
    public double DistributionFunction(double x) {
        return 0.3183098861837907 * Math.atan2(x - this.location, this.scale) + 0.5;
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double z = (x - this.location) / this.scale;
        return this.constant / (1.0 + z * z);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double z = (x - this.location) / this.scale;
        return this.lnconstant - Math.log(1.0 + z * z);
    }
}

