/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Neuro.ActivationFunction;

import Catalano.Neuro.ActivationFunction.IActivationFunction;

public class BipolarSigmoidFunction
implements IActivationFunction {
    private double alpha = 2.0;

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public BipolarSigmoidFunction() {
    }

    public BipolarSigmoidFunction(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double Function(double x) {
        return 2.0 / (1.0 + Math.exp(-this.alpha * x)) - 1.0;
    }

    @Override
    public double Derivative(double x) {
        double y = this.Function(x);
        return this.alpha * (1.0 - y * y) / 2.0;
    }

    @Override
    public double Derivative2(double x) {
        return this.alpha * (1.0 - x * x) / 2.0;
    }
}

