/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Random;

import Catalano.Math.Random.IRandomNumberGenerator;
import Catalano.Math.Random.UniversalGenerator;

public class Random {
    private IRandomNumberGenerator rng;
    private long seed;

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public Random() {
        this(new UniversalGenerator());
    }

    public Random(long seed) {
        this(new UniversalGenerator(seed));
    }

    public Random(IRandomNumberGenerator rng) {
        this.rng = rng;
    }

    public double nextDouble() {
        return this.rng.nextDouble();
    }

    public void nextDoubles(double[] d) {
        this.rng.nextDoubles(d);
    }

    public double nextDouble(double lo, double hi) {
        if (lo < 0.0) {
            if (this.nextInt(2) == 0) {
                return -this.nextDouble(0.0, -lo);
            }
            return this.nextDouble(0.0, hi);
        }
        return lo + (hi - lo) * this.nextDouble();
    }

    public void nextDoubles(double[] d, double lo, double hi) {
        this.rng.nextDoubles(d);
        double l = hi - lo;
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = lo + l * d[i];
        }
    }

    public int nextInt() {
        return this.rng.nextInt();
    }

    public int nextInt(int n) {
        return this.rng.nextInt(n);
    }

    public long nextLong() {
        return this.rng.nextLong();
    }

    public int[] permutate(int n) {
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = i;
        }
        this.permutate(x);
        return x;
    }

    public void permutate(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            int s = x[i];
            x[i] = x[j];
            x[j] = s;
        }
    }

    public void permutate(float[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            float s = x[i];
            x[i] = x[j];
            x[j] = s;
        }
    }

    public void permutate(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            double s = x[i];
            x[i] = x[j];
            x[j] = s;
        }
    }

    public void permutate(Object[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Object s = x[i];
            x[i] = x[j];
            x[j] = s;
        }
    }
}

