/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Optimization;

import Catalano.Math.Optimization.Constraint;
import Catalano.Math.Optimization.LinearProgramming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class MixedIntegerLinearProgramming {
    public static final int INFEASIBLE = 0;
    public static final int OPTIMAL = 1;
    public static final int UNBOUNDED = 2;
    private double tolL = 1.0E-5;
    private double tolU = 0.99999;
    private Objective objective;
    private LinearProgramming simplex;
    private int maxIteration = 100;
    private int[] type;
    private Solution sol;

    public void setType(int[] type) {
        this.type = type;
    }

    public double[] getCoefficients() {
        return this.sol.coef;
    }

    public double getSolution() {
        return this.sol.z;
    }

    public MixedIntegerLinearProgramming(Objective objective) {
        this(objective, 1.0E-5);
    }

    public MixedIntegerLinearProgramming(Objective objective, double tol) {
        this.objective = objective;
        this.tolL = tol;
        this.tolU = 1.0 - tol;
    }

    public int Solve(double[] function, List<Constraint> constraint) {
        int iter = 0;
        if (this.type == null) {
            throw new IllegalArgumentException("The data type must be definied.");
        }
        double value = Double.NaN;
        this.simplex = this.objective == Objective.Maximize ? new LinearProgramming(LinearProgramming.Objective.Maximize) : new LinearProgramming(LinearProgramming.Objective.Minimize);
        int status = this.simplex.Solve(function, constraint);
        if (status == 1) {
            boolean c = this.CheckSolution(this.simplex.getCoefficients(), function.length);
            if (c) {
                return 1;
            }
            Stack<List<Constraint>> stack = new Stack<List<Constraint>>();
            this.BranchAndBound(stack, constraint, this.simplex.getCoefficients(), function.length);
            ArrayList<Solution> solutions = new ArrayList<Solution>();
            while (stack.size() > 0 && iter != this.maxIteration) {
                ++iter;
                List<Constraint> p = stack.pop();
                int s = this.simplex.Solve(function, p);
                if (s != 1) continue;
                boolean b = this.CheckSolution(this.simplex.getCoefficients(), function.length);
                if (this.objective == Objective.Maximize) {
                    if (b) {
                        solutions.add(new Solution(this.simplex.getCoefficients(), this.simplex.getSolution()));
                        if (Double.isNaN(value)) {
                            value = this.simplex.getSolution();
                        }
                        value = Math.max(value, this.simplex.getSolution());
                        continue;
                    }
                    if (Double.isNaN(value)) {
                        this.BranchAndBound(stack, p, this.simplex.getCoefficients(), function.length);
                    }
                    if (Double.isNaN(value) || !(this.simplex.getSolution() > value)) continue;
                    this.BranchAndBound(stack, p, this.simplex.getCoefficients(), function.length);
                    continue;
                }
                if (b) {
                    solutions.add(new Solution(this.simplex.getCoefficients(), this.simplex.getSolution()));
                    if (Double.isNaN(value)) {
                        value = this.simplex.getSolution();
                    }
                    value = Math.min(value, this.simplex.getSolution());
                    continue;
                }
                if (Double.isNaN(value)) {
                    this.BranchAndBound(stack, p, this.simplex.getCoefficients(), function.length);
                }
                if (Double.isNaN(value) || !(this.simplex.getSolution() < value)) continue;
                this.BranchAndBound(stack, p, this.simplex.getCoefficients(), function.length);
            }
            if (solutions.isEmpty()) {
                return 0;
            }
            if (this.objective == Objective.Maximize) {
                Collections.sort(solutions, new Comparator<Solution>(){

                    @Override
                    public int compare(Solution o1, Solution o2) {
                        return Double.compare(o2.z, o1.z);
                    }
                });
            } else {
                Collections.sort(solutions, new Comparator<Solution>(){

                    @Override
                    public int compare(Solution o1, Solution o2) {
                        return Double.compare(o1.z, o2.z);
                    }
                });
            }
            this.sol = (Solution)solutions.get(0);
            return 1;
        }
        return status;
    }

    private void BranchAndBound(Stack<List<Constraint>> stack, List<Constraint> constraint, double[] solution, int n) {
        int index = this.GetUpperValue(solution, n);
        double lower = Math.floor(solution[index]);
        double upper = Math.ceil(solution[index]);
        double[] v = new double[n];
        v[index] = 1.0;
        ArrayList<Constraint> c1 = new ArrayList<Constraint>(constraint);
        c1.add(new Constraint(v, Constraint.Symbol.GREATER_THAN, upper));
        ArrayList<Constraint> c2 = new ArrayList<Constraint>(constraint);
        c2.add(new Constraint(v, Constraint.Symbol.LESS_THAN, lower));
        stack.add(c1);
        stack.add(c2);
    }

    private int GetUpperValue(double[] solution, int n) {
        double min = -1.7976931348623157E308;
        int index = -1;
        for (int i = 0; i < n; ++i) {
            if (solution[i] % 1.0 == 0.0 || !(solution[i] > min)) continue;
            min = Math.max(min, solution[i]);
            index = i;
        }
        return index;
    }

    private boolean CheckSolution(double[] solution, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.type[i] != 1 || this.isInteger(solution[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isInteger(double value) {
        double d = Math.abs(Math.floor(value) - value);
        if (d < this.tolL) {
            return true;
        }
        if (d - this.tolU >= 0.0) {
            return true;
        }
        return d < this.tolL;
    }

    class Solution {
        private double[] coef;
        private double z;

        public Solution(double[] coef, double z) {
            this.coef = coef;
            this.z = z;
        }
    }

    public static enum Objective {
        Minimize,
        Maximize;

    }
}

