/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Core.ArraysUtil;
import Catalano.Core.DoubleRange;
import Catalano.Core.IntPoint;
import Catalano.Math.Decompositions.LUDecomposition;
import Catalano.Math.Decompositions.SingularValueDecomposition;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class Matrix {
    private Matrix() {
    }

    public static double[][] Abs(double[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        double[][] r = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                r[i][j] = Math.abs(A[i][j]);
            }
        }
        return r;
    }

    public static int[][] Abs(int[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        int[][] r = new int[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                r[i][j] = Math.abs(A[i][j]);
            }
        }
        return r;
    }

    public static float[][] Abs(float[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        float[][] r = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                r[i][j] = Math.abs(A[i][j]);
            }
        }
        return r;
    }

    public static double[] CreateMatrix1D(int size, double val) {
        double[] v = new double[size];
        for (int i = 0; i < size; ++i) {
            v[i] = val;
        }
        return v;
    }

    public static int[] CreateMatrix1D(int size, int val) {
        int[] v = new int[size];
        for (int i = 0; i < size; ++i) {
            v[i] = val;
        }
        return v;
    }

    public static float[] CreateMatrix1D(int size, float val) {
        float[] v = new float[size];
        for (int i = 0; i < size; ++i) {
            v[i] = val;
        }
        return v;
    }

    public static double[][] CreateMatrix2D(int height, int width, double val) {
        double[][] v = new double[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                v[i][j] = val;
            }
        }
        return v;
    }

    public static int[][] CreateMatrix2D(int height, int width, int val) {
        int[][] v = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                v[i][j] = val;
            }
        }
        return v;
    }

    public static float[][] CreateMatrix2D(int height, int width, float val) {
        float[][] v = new float[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                v[i][j] = val;
            }
        }
        return v;
    }

    public static int[] Indices(int from, int to) {
        int[] vector = new int[to - from];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = from++;
        }
        return vector;
    }

    public static double InnerProduct(double[] A, double[] B) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i] * B[i];
        }
        return sum;
    }

    public static int InnerProduct(int[] A, int[] B) {
        int sum = 0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i] * B[i];
        }
        return sum;
    }

    public static float InnerProduct(float[] A, float[] B) {
        float sum = 0.0f;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i] * B[i];
        }
        return sum;
    }

    public static double[] InsertColumns(double[] A, double[] B, int index) {
        if (index > A.length) {
            throw new IllegalArgumentException("The index must be at least a valid index inside the array A.");
        }
        double[] v = new double[A.length + B.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i != index) {
                v[idx] = A[i];
                ++idx;
                continue;
            }
            for (int j = 0; j < B.length; ++j) {
                v[i + j] = B[j];
                ++idx;
            }
            v[idx++] = A[i];
        }
        if (index == A.length) {
            for (int j = 0; j < B.length; ++j) {
                v[A.length + j] = B[j];
            }
        }
        return v;
    }

    public static int[] InsertColumns(int[] A, int[] B, int index) {
        if (index > A.length) {
            throw new IllegalArgumentException("The index must be at least a valid index inside the array A.");
        }
        int[] v = new int[A.length + B.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i != index) {
                v[idx] = A[i];
                ++idx;
                continue;
            }
            for (int j = 0; j < B.length; ++j) {
                v[i + j] = B[j];
                ++idx;
            }
            v[idx++] = A[i];
        }
        if (index == A.length) {
            for (int j = 0; j < B.length; ++j) {
                v[A.length + j] = B[j];
            }
        }
        return v;
    }

    public static float[] InsertColumns(float[] A, float[] B, int index) {
        if (index > A.length) {
            throw new IllegalArgumentException("The index must be at least a valid index inside the array A.");
        }
        float[] v = new float[A.length + B.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i != index) {
                v[idx] = A[i];
                ++idx;
                continue;
            }
            for (int j = 0; j < B.length; ++j) {
                v[i + j] = B[j];
                ++idx;
            }
            v[idx++] = A[i];
        }
        if (index == A.length) {
            for (int j = 0; j < B.length; ++j) {
                v[A.length + j] = B[j];
            }
        }
        return v;
    }

    public static byte[] InsertColumns(byte[] A, byte[] B, int index) {
        if (index > A.length) {
            throw new IllegalArgumentException("The index must be at least a valid index inside the array A.");
        }
        byte[] v = new byte[A.length + B.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i != index) {
                v[idx] = A[i];
                ++idx;
                continue;
            }
            for (int j = 0; j < B.length; ++j) {
                v[i + j] = B[j];
                ++idx;
            }
            v[idx++] = A[i];
        }
        if (index == A.length) {
            for (int j = 0; j < B.length; ++j) {
                v[A.length + j] = B[j];
            }
        }
        return v;
    }

    public static Object[] InsertColumns(Object[] A, Object[] B, int index) {
        if (index > A.length) {
            throw new IllegalArgumentException("The index must be at least a valid index inside the array A.");
        }
        Object[] v = new Object[A.length + B.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i != index) {
                v[idx] = A[i];
                ++idx;
                continue;
            }
            for (int j = 0; j < B.length; ++j) {
                v[i + j] = B[j];
                ++idx;
            }
            v[idx++] = A[i];
        }
        if (index == A.length) {
            for (int j = 0; j < B.length; ++j) {
                v[A.length + j] = B[j];
            }
        }
        return v;
    }

    public static double[][] InsertColumn(double[][] A, double[] B, int index) {
        int i;
        if (A.length != B.length) {
            throw new IllegalArgumentException("The column of the matrix must be the same size of the vector B.");
        }
        double[][] mat = new double[A.length][A[0].length + 1];
        for (i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j <= A[0].length; ++j) {
                if (j == index) continue;
                mat[i][j] = A[i][idx];
                ++idx;
            }
        }
        for (i = 0; i < B.length; ++i) {
            mat[i][index] = B[i];
        }
        return mat;
    }

    public static int[][] InsertColumn(int[][] A, int[] B, int index) {
        int i;
        if (A.length != B.length) {
            throw new IllegalArgumentException("The column of the matrix must be the same size of the vector B.");
        }
        int[][] mat = new int[A.length][A[0].length + 1];
        for (i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j <= A[0].length; ++j) {
                if (j == index) continue;
                mat[i][j] = A[i][idx];
                ++idx;
            }
        }
        for (i = 0; i < B.length; ++i) {
            mat[i][index] = B[i];
        }
        return mat;
    }

    public static float[][] InsertColumn(float[][] A, float[] B, int index) {
        int i;
        if (A.length != B.length) {
            throw new IllegalArgumentException("The column of the matrix must be the same size of the vector B.");
        }
        float[][] mat = new float[A.length][A[0].length + 1];
        for (i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j <= A[0].length; ++j) {
                if (j == index) continue;
                mat[i][j] = A[i][idx];
                ++idx;
            }
        }
        for (i = 0; i < B.length; ++i) {
            mat[i][index] = B[i];
        }
        return mat;
    }

    public static double[][] InsertColumns(double[][] A, double[][] B, int index) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("The rows of the matrix must be the same size of the rows of B.");
        }
        if (index > A[0].length) {
            throw new IllegalArgumentException("The index must be in the range [0..number of columns + 1]");
        }
        double[][] mat = new double[A.length][A[0].length + B[0].length];
        for (int i = 0; i < A.length; ++i) {
            int k;
            int j;
            int idx = 0;
            for (j = 0; j < A[0].length; ++j) {
                if (j != index) {
                    mat[i][idx] = A[i][j];
                    ++idx;
                    continue;
                }
                for (k = 0; k < B[0].length; ++k) {
                    mat[i][j + k] = B[i][k];
                }
                mat[i][idx += B[0].length] = A[i][j];
                ++idx;
            }
            if (j != index) continue;
            for (k = 0; k < B[0].length; ++k) {
                mat[i][j + k] = B[i][k];
            }
        }
        return mat;
    }

    public static int[][] InsertColumns(int[][] A, int[][] B, int index) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("The rows of the matrix must be the same size of the rows of B.");
        }
        if (index > A[0].length) {
            throw new IllegalArgumentException("The index must be in the range [0..number of columns + 1]");
        }
        int[][] mat = new int[A.length][A[0].length + B[0].length];
        for (int i = 0; i < A.length; ++i) {
            int k;
            int j;
            int idx = 0;
            for (j = 0; j < A[0].length; ++j) {
                if (j != index) {
                    mat[i][idx] = A[i][j];
                    ++idx;
                    continue;
                }
                for (k = 0; k < B[0].length; ++k) {
                    mat[i][j + k] = B[i][k];
                }
                mat[i][idx += B[0].length] = A[i][j];
                ++idx;
            }
            if (j != index) continue;
            for (k = 0; k < B[0].length; ++k) {
                mat[i][j + k] = B[i][k];
            }
        }
        return mat;
    }

    public static float[][] InsertColumns(float[][] A, float[][] B, int index) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("The rows of the matrix must be the same size of the rows of B.");
        }
        if (index > A[0].length) {
            throw new IllegalArgumentException("The index must be in the range [0..number of columns + 1]");
        }
        float[][] mat = new float[A.length][A[0].length + B[0].length];
        for (int i = 0; i < A.length; ++i) {
            int k;
            int j;
            int idx = 0;
            for (j = 0; j < A[0].length; ++j) {
                if (j != index) {
                    mat[i][idx] = A[i][j];
                    ++idx;
                    continue;
                }
                for (k = 0; k < B[0].length; ++k) {
                    mat[i][j + k] = B[i][k];
                }
                mat[i][idx += B[0].length] = A[i][j];
                ++idx;
            }
            if (j != index) continue;
            for (k = 0; k < B[0].length; ++k) {
                mat[i][j + k] = B[i][k];
            }
        }
        return mat;
    }

    public static double[] Log(double[] A) {
        int size = A.length;
        double[] r = new double[size];
        for (int i = 0; i < size; ++i) {
            r[i] = Math.log(A[i]);
        }
        return r;
    }

    public static double[][] Log(double[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        double[][] r = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                r[i][j] = Math.log(A[i][j]);
            }
        }
        return r;
    }

    public static double[] Add(double[] A, double[] B) {
        for (int i = 0; i < A.length; ++i) {
            int n = i;
            A[n] = A[n] + B[i];
        }
        return B;
    }

    public static int[] Add(int[] A, int[] B) {
        for (int i = 0; i < A.length; ++i) {
            int n = i;
            A[n] = A[n] + B[i];
        }
        return B;
    }

    public static float[] Add(float[] A, float[] B) {
        for (int i = 0; i < A.length; ++i) {
            int n = i;
            A[n] = A[n] + B[i];
        }
        return B;
    }

    public static double[][] Add(double[][] A, double[][] B) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                double[] dArray = A[i];
                int n = j;
                dArray[n] = dArray[n] + B[i][j];
            }
        }
        return A;
    }

    public static int[][] Add(int[][] A, int[][] B) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                int[] nArray = A[i];
                int n = j;
                nArray[n] = nArray[n] + B[i][j];
            }
        }
        return A;
    }

    public static float[][] Add(float[][] A, float[][] B) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                float[] fArray = A[i];
                int n = j;
                fArray[n] = fArray[n] + B[i][j];
            }
        }
        return A;
    }

    public static void Add(double[] A, double scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] + scalar;
        }
    }

    public static void Add(int[] A, int scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] + scalar;
        }
    }

    public static void Add(float[] A, float scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] + scalar;
        }
    }

    public static void Add(double[][] A, double scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                double[] dArray = A[i];
                int n = j++;
                dArray[n] = dArray[n] + scalar;
            }
        }
    }

    public static void Add(int[][] A, int scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                int[] nArray = A[i];
                int n = j++;
                nArray[n] = nArray[n] + scalar;
            }
        }
    }

    public static void Add(float[][] A, float scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                float[] fArray = A[i];
                int n = j++;
                fArray[n] = fArray[n] + scalar;
            }
        }
    }

    public static void Clear(int[] A) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = 0;
        }
    }

    public static void Clear(float[] A) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = 0.0f;
        }
    }

    public static void Clear(double[] A) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = 0.0;
        }
    }

    public static void Clear(int[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = 0;
            }
        }
    }

    public static void Clear(float[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = 0.0f;
            }
        }
    }

    public static void Clear(double[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = 0.0;
            }
        }
    }

    public static double[][] Copy(double[][] A) {
        double[][] m = new double[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[i][j] = A[i][j];
            }
        }
        return m;
    }

    public static int[][] Copy(int[][] A) {
        int[][] m = new int[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[i][j] = A[i][j];
            }
        }
        return m;
    }

    public static float[][] Copy(float[][] A) {
        float[][] m = new float[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[i][j] = A[i][j];
            }
        }
        return m;
    }

    public static double Determinant(double[][] A) {
        return new LUDecomposition(A).determinant();
    }

    public static double[] Diff(double[] A, int differences) {
        double[] result = new double[A.length - differences];
        for (int i = 0; i < result.length; ++i) {
            result[i] = A[i + differences] - A[i];
        }
        return result;
    }

    public static int[] Diff(int[] A, int differences) {
        int[] result = new int[A.length - differences];
        for (int i = 0; i < result.length; ++i) {
            result[i] = A[i + differences] - A[i];
        }
        return result;
    }

    public static float[] Diff(float[] A, int differences) {
        float[] result = new float[A.length - differences];
        for (int i = 0; i < result.length; ++i) {
            result[i] = A[i + differences] - A[i];
        }
        return result;
    }

    public static void Divide(double[][] A, double scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                double[] dArray = A[i];
                int n = j++;
                dArray[n] = dArray[n] / scalar;
            }
        }
    }

    public static double[][] Exp(double[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        double[][] r = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                r[i][j] = Math.exp(A[i][j]);
            }
        }
        return r;
    }

    public static void Divide(int[][] A, int scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                int[] nArray = A[i];
                int n = j++;
                nArray[n] = nArray[n] / scalar;
            }
        }
    }

    public static void Divide(float[][] A, float scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                float[] fArray = A[i];
                int n = j++;
                fArray[n] = fArray[n] / scalar;
            }
        }
    }

    public static double[][] DotProduct(double[][] A, double[][] B) {
        double[][] result = new double[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * B[i][j];
            }
        }
        return result;
    }

    public static int[][] DotProduct(int[][] A, int[][] B) {
        int[][] result = new int[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * B[i][j];
            }
        }
        return result;
    }

    public static float[][] DotProduct(float[][] A, float[][] B) {
        float[][] result = new float[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * B[i][j];
            }
        }
        return result;
    }

    public static void Fill(double[] A, double number) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = number;
        }
    }

    public static double[] getColumn(double[][] A, int n) {
        int rows = A.length;
        double[] v = new double[rows];
        for (int i = 0; i < rows; ++i) {
            v[i] = A[i][n];
        }
        return v;
    }

    public static int[] getColumn(int[][] A, int n) {
        int rows = A.length;
        int[] v = new int[rows];
        for (int i = 0; i < rows; ++i) {
            v[i] = A[i][n];
        }
        return v;
    }

    public static float[] getColumn(float[][] A, int n) {
        int rows = A.length;
        float[] v = new float[rows];
        for (int i = 0; i < rows; ++i) {
            v[i] = A[i][n];
        }
        return v;
    }

    public static <T> T[] getColumn(T[][] A, int n) {
        int rows = A.length;
        Object[] v = (Object[])Array.newInstance(A[0][n].getClass(), rows);
        for (int i = 0; i < rows; ++i) {
            v[i] = A[i][n];
        }
        return v;
    }

    public static double[] getColumns(double[] A, int[] indexes) {
        double[] v = new double[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static int[] getColumns(int[] A, int[] indexes) {
        int[] v = new int[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static float[] getColumns(float[] A, int[] indexes) {
        float[] v = new float[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static <T> T[] getColumns(T[] A, int[] indexes) {
        Object[] v = (Object[])Array.newInstance(A[0].getClass(), indexes.length);
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static double[] getColumns(double[] A, int startIndex, int endIndex) {
        double[] v = new double[endIndex - startIndex + 1];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[startIndex + i];
        }
        return v;
    }

    public static int[] getColumns(int[] A, int startIndex, int endIndex) {
        int[] v = new int[endIndex - startIndex + 1];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[startIndex + i];
        }
        return v;
    }

    public static float[] getColumns(float[] A, int startIndex, int endIndex) {
        float[] v = new float[endIndex - startIndex + 1];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[startIndex + i];
        }
        return v;
    }

    public static <T> T[] getColumns(T[] A, int startIndex, int endIndex) {
        Object[] v = (Object[])Array.newInstance(A[0].getClass(), A.length);
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[startIndex + i];
        }
        return v;
    }

    public static double[][] getColumns(double[][] A, int[] indexes) {
        double[][] m = new double[A.length][indexes.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[i][indexes[j]];
            }
        }
        return m;
    }

    public static int[][] getColumns(int[][] A, int[] indexes) {
        int[][] m = new int[A.length][indexes.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[i][indexes[j]];
            }
        }
        return m;
    }

    public static float[][] getColumns(float[][] A, int[] indexes) {
        float[][] m = new float[A.length][indexes.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[i][indexes[j]];
            }
        }
        return m;
    }

    public static <T> T[][] getColumns(T[][] A, int[] indexes) {
        Object[][] m = (Object[][])Array.newInstance(A[0][0].getClass(), A.length, indexes.length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[i][indexes[j]];
            }
        }
        return m;
    }

    public static double[] getRow(double[][] A, int n) {
        int cols = A[0].length;
        double[] v = new double[cols];
        for (int i = 0; i < cols; ++i) {
            v[i] = A[n][i];
        }
        return v;
    }

    public static int[] getRow(int[][] A, int n) {
        int cols = A[0].length;
        int[] v = new int[cols];
        for (int i = 0; i < cols; ++i) {
            v[i] = A[n][i];
        }
        return v;
    }

    public static float[] getRow(float[][] A, int n) {
        int cols = A[0].length;
        float[] v = new float[cols];
        for (int i = 0; i < cols; ++i) {
            v[i] = A[n][i];
        }
        return v;
    }

    public static double[][] getRows(double[][] A, int[] indexes) {
        double[][] m = new double[indexes.length][A[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[indexes[i]][j];
            }
        }
        return m;
    }

    public static int[][] getRows(int[][] A, int[] indexes) {
        int[][] m = new int[indexes.length][A[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[indexes[i]][j];
            }
        }
        return m;
    }

    public static float[][] getRows(float[][] A, int[] indexes) {
        float[][] m = new float[indexes.length][A[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = A[indexes[i]][j];
            }
        }
        return m;
    }

    public static double[] getRows(double[] A, int[] indexes) {
        double[] v = new double[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static int[] getRows(int[] A, int[] indexes) {
        int[] v = new int[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static float[] getRows(float[] A, int[] indexes) {
        float[] v = new float[indexes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static <T> T[] getRows(T[] A, int[] indexes) {
        Object[] v = (Object[])Array.newInstance(A[0].getClass(), indexes.length);
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[indexes[i]];
        }
        return v;
    }

    public static void Fill(int[] A, int number) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = number;
        }
    }

    public static void Fill(float[] A, float number) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = number;
        }
    }

    public static void Fill(double[][] A, double number) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = number;
            }
        }
    }

    public static void Fill(int[][] A, int number) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = number;
            }
        }
    }

    public static void Fill(float[][] A, float number) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                A[i][j] = number;
            }
        }
    }

    public static double[] Subtract(double[] A, double[] B) {
        double[] r = new double[A.length];
        for (int i = 0; i < A.length; ++i) {
            r[i] = A[i] - B[i];
        }
        return r;
    }

    public static int[] Subtract(int[] A, int[] B) {
        int[] r = new int[A.length];
        for (int i = 0; i < A.length; ++i) {
            r[i] = A[i] - B[i];
        }
        return r;
    }

    public static float[] Subtract(float[] A, float[] B) {
        float[] r = new float[A.length];
        for (int i = 0; i < A.length; ++i) {
            r[i] = A[i] - B[i];
        }
        return r;
    }

    public static double[][] Subtract(double[][] A, double[][] B) {
        double[][] r = new double[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                r[i][j] = A[i][j] - B[i][j];
            }
        }
        return r;
    }

    public static int[][] Subtract(int[][] A, int[][] B) {
        int[][] r = new int[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                r[i][j] = A[i][j] - B[i][j];
            }
        }
        return r;
    }

    public static float[][] Subtract(float[][] A, float[][] B) {
        float[][] r = new float[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                r[i][j] = A[i][j] - B[i][j];
            }
        }
        return r;
    }

    public static void Subtract(double[] A, double scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] - scalar;
        }
    }

    public static void Subtract(int[] A, int scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] - scalar;
        }
    }

    public static void Subtract(float[] A, float scalar) {
        int i = 0;
        while (i < A.length) {
            int n = i++;
            A[n] = A[n] - scalar;
        }
    }

    public static double Sum(double[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += A[i][j];
            }
        }
        return sum;
    }

    public static int Sum(int[][] A) {
        int sum = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += A[i][j];
            }
        }
        return sum;
    }

    public static float Sum(float[][] A) {
        float sum = 0.0f;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += A[i][j];
            }
        }
        return sum;
    }

    public static double SumAbs(double[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += Math.abs(A[i][j]);
            }
        }
        return sum;
    }

    public static int SumAbs(int[][] A) {
        int sum = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += Math.abs(A[i][j]);
            }
        }
        return sum;
    }

    public static float SumAbs(float[][] A) {
        float sum = 0.0f;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += Math.abs(A[i][j]);
            }
        }
        return sum;
    }

    public static void Subtract(double[][] A, double scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                double[] dArray = A[i];
                int n = j++;
                dArray[n] = dArray[n] - scalar;
            }
        }
    }

    public static void Subtract(int[][] A, int scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                int[] nArray = A[i];
                int n = j++;
                nArray[n] = nArray[n] - scalar;
            }
        }
    }

    public static void Subtract(float[][] A, float scalar) {
        for (int i = 0; i < A.length; ++i) {
            int j = 0;
            while (j < A[0].length) {
                float[] fArray = A[i];
                int n = j++;
                fArray[n] = fArray[n] - scalar;
            }
        }
    }

    public static void SwapColumn(double[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                double t2;
                double t1 = A[i][a];
                A[i][a] = t2 = A[i][b];
                A[i][b] = t1;
            }
        }
    }

    public static void SwapColumn(int[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                int t2;
                int t1 = A[i][a];
                A[i][a] = t2 = A[i][b];
                A[i][b] = t1;
            }
        }
    }

    public static void SwapColumn(float[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                float t2;
                float t1 = A[i][a];
                A[i][a] = t2 = A[i][b];
                A[i][b] = t1;
            }
        }
    }

    public static void SwapRow(double[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                double t2;
                double t1 = A[a][j];
                A[a][j] = t2 = A[b][j];
                A[b][j] = t1;
            }
        }
    }

    public static void SwapRow(int[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                int t2;
                int t1 = A[a][j];
                A[a][j] = t2 = A[b][j];
                A[b][j] = t1;
            }
        }
    }

    public static void SwapRow(float[][] A, int a, int b) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                float t2;
                float t1 = A[a][j];
                A[a][j] = t2 = A[b][j];
                A[b][j] = t1;
            }
        }
    }

    public static double[] Multiply(double[] A, double scalar) {
        double[] r = new double[A.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = A[i] * scalar;
        }
        return r;
    }

    public static int[] Multiply(int[] A, int scalar) {
        int[] r = new int[A.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = A[i] * scalar;
        }
        return r;
    }

    public static float[] Multiply(float[] A, float scalar) {
        float[] r = new float[A.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = A[i] * scalar;
        }
        return r;
    }

    public static double[][] Multiply(double[][] A, double[][] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("Illegal matrix dimensions.");
        }
        double[][] result = new double[A.length][B[0].length];
        int n = A[0].length;
        int m = A.length;
        int p = B[0].length;
        double[] Bcolj = new double[n];
        for (int j = 0; j < p; ++j) {
            for (int k = 0; k < n; ++k) {
                Bcolj[k] = B[k][j];
            }
            for (int i = 0; i < m; ++i) {
                double[] Arowi = A[i];
                double s = 0.0;
                for (int k = 0; k < n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                result[i][j] = s;
            }
        }
        return result;
    }

    public static int[][] Multiply(int[][] A, int[][] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("Illegal matrix dimensions.");
        }
        int[][] result = new int[A.length][B[0].length];
        int n = A[0].length;
        int m = A.length;
        int p = B[0].length;
        int[] Bcolj = new int[n];
        for (int j = 0; j < p; ++j) {
            for (int k = 0; k < n; ++k) {
                Bcolj[k] = B[k][j];
            }
            for (int i = 0; i < m; ++i) {
                int[] Arowi = A[i];
                int s = 0;
                for (int k = 0; k < n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                result[i][j] = s;
            }
        }
        return result;
    }

    public static double[] Multiply(double[] A, double[][] B) {
        double[] r = new double[B[0].length];
        for (int j = 0; j < B[0].length; ++j) {
            for (int i = 0; i < B.length; ++i) {
                int n = j;
                r[n] = r[n] + A[i] * B[i][j];
            }
        }
        return r;
    }

    public static int[] Multiply(int[] A, int[][] B) {
        int[] r = new int[B[0].length];
        for (int j = 0; j < B[0].length; ++j) {
            for (int i = 0; i < B.length; ++i) {
                int n = j;
                r[n] = r[n] + A[i] * B[i][j];
            }
        }
        return r;
    }

    public static float[] Multiply(float[] A, float[][] B) {
        float[] r = new float[B[0].length];
        for (int j = 0; j < B[0].length; ++j) {
            for (int i = 0; i < B.length; ++i) {
                int n = j;
                r[n] = r[n] + A[i] * B[i][j];
            }
        }
        return r;
    }

    public static float[][] Multiply(float[][] A, float[][] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("Illegal matrix dimensions.");
        }
        float[][] result = new float[A.length][B[0].length];
        int n = A[0].length;
        int m = A.length;
        int p = B[0].length;
        float[] Bcolj = new float[n];
        for (int j = 0; j < p; ++j) {
            for (int k = 0; k < n; ++k) {
                Bcolj[k] = B[k][j];
            }
            for (int i = 0; i < m; ++i) {
                float[] Arowi = A[i];
                float s = 0.0f;
                for (int k = 0; k < n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                result[i][j] = s;
            }
        }
        return result;
    }

    public static double[][] Multiply(double[][] A, double value) {
        double[][] result = new double[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * value;
            }
        }
        return result;
    }

    public static float[][] Multiply(float[][] A, float value) {
        float[][] result = new float[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * value;
            }
        }
        return result;
    }

    public static int[][] Multiply(int[][] A, int value) {
        int[][] result = new int[A.length][A[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                result[i][j] = A[i][j] * value;
            }
        }
        return result;
    }

    public static double[][] MultiplyByDiagonal(double[][] A, double[] B) {
        double[][] r = new double[A.length][B.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r[0].length; ++j) {
                r[i][j] = A[i][j] * B[j];
            }
        }
        return r;
    }

    public static double[][] MultiplyByTranspose(double[][] A) {
        return Matrix.Multiply(A, Matrix.Transpose(A));
    }

    public static int[][] MultiplyByTranspose(int[][] A) {
        return Matrix.Multiply(A, Matrix.Transpose(A));
    }

    public static float[][] MultiplyByTranspose(float[][] A) {
        return Matrix.Multiply(A, Matrix.Transpose(A));
    }

    public static double[][] MultiplyByTranspose(double[][] A, double[][] B) {
        return Matrix.Multiply(A, Matrix.Transpose(B));
    }

    public static int[][] MultiplyByTranspose(int[][] A, int[][] B) {
        return Matrix.Multiply(A, Matrix.Transpose(B));
    }

    public static float[][] MultiplyByTranspose(float[][] A, float[][] B) {
        return Matrix.Multiply(A, Matrix.Transpose(B));
    }

    public static double[] MultiplyByTranspose(double[][] A, double[] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("The columns of the matrix A must be the same of the vector B");
        }
        double[] result = new double[A.length];
        for (int i = 0; i < A.length; ++i) {
            double r = 0.0;
            for (int j = 0; j < A[0].length; ++j) {
                r += A[i][j] * B[j];
            }
            result[i] = r;
        }
        return result;
    }

    public static int[] MultiplyByTranspose(int[][] A, int[] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("The columns of the matrix A must be the same of the vector B");
        }
        int[] result = new int[A.length];
        for (int i = 0; i < A.length; ++i) {
            int r = 0;
            for (int j = 0; j < A[0].length; ++j) {
                r += A[i][j] * B[j];
            }
            result[i] = r;
        }
        return result;
    }

    public static float[] MultiplyByTranspose(float[][] A, float[] B) {
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("The columns of the matrix A must be the same of the vector B");
        }
        float[] result = new float[A.length];
        for (int i = 0; i < A.length; ++i) {
            float r = 0.0f;
            for (int j = 0; j < A[0].length; ++j) {
                r += A[i][j] * B[j];
            }
            result[i] = r;
        }
        return result;
    }

    public static double Norm1(double[][] A) {
        double max = 0.0;
        for (int j = 0; j < A[0].length; ++j) {
            double sum = 0.0;
            for (int i = 0; i < A.length; ++i) {
                sum += Math.abs(A[i][j]);
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    public static int Norm1(int[][] A) {
        int max = 0;
        for (int j = 0; j < A[0].length; ++j) {
            int sum = 0;
            for (int i = 0; i < A.length; ++i) {
                sum += Math.abs(A[i][j]);
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    public static float Norm1(float[][] A) {
        float max = 0.0f;
        for (int j = 0; j < A[0].length; ++j) {
            float sum = 0.0f;
            for (int i = 0; i < A.length; ++i) {
                sum += Math.abs(A[i][j]);
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    public static double Norm2(double[] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += Math.pow(Math.abs(A[i]), 2.0);
        }
        return Math.sqrt(sum);
    }

    public static double Norm2(double[][] A) {
        return new SingularValueDecomposition(A).getS()[0][0];
    }

    public static double NormF(double[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += Math.pow(Math.abs(A[i][j]), 2.0);
            }
        }
        return Math.sqrt(sum);
    }

    public static double NormF(int[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum += Math.pow(Math.abs(A[i][j]), 2.0);
            }
        }
        return Math.sqrt(sum);
    }

    public static float NormF(float[][] A) {
        float sum = 0.0f;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                sum = (float)((double)sum + Math.pow(Math.abs(A[i][j]), 2.0));
            }
        }
        return (float)Math.sqrt(sum);
    }

    public static double NormP(double[] v, int p) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += Math.pow(Math.abs(v[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double[][] OuterProduct(double[] u) {
        return Matrix.OuterProduct(u, u);
    }

    public static double[][] OuterProduct(double[] u, double[] v) {
        double[][] r = new double[u.length][v.length];
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                r[i][j] = u[i] * v[j];
            }
        }
        return r;
    }

    public static int[][] OuterProduct(int[] u) {
        return Matrix.OuterProduct(u, u);
    }

    public static int[][] OuterProduct(int[] u, int[] v) {
        int[][] r = new int[u.length][v.length];
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                r[i][j] = u[i] * v[j];
            }
        }
        return r;
    }

    public static float[][] OuterProduct(float[] u) {
        return Matrix.OuterProduct(u, u);
    }

    public static float[][] OuterProduct(float[] u, float[] v) {
        float[][] r = new float[u.length][v.length];
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                r[i][j] = u[i] * v[j];
            }
        }
        return r;
    }

    public static double[][] PseudoInverse(double[][] A) {
        return new SingularValueDecomposition(A).inverse();
    }

    public static double Trace(double[][] A) {
        if (Matrix.isSquare(A)) {
            double sum = 0.0;
            for (int i = 0; i < A.length; ++i) {
                sum += A[i][i];
            }
            return sum;
        }
        throw new IllegalArgumentException("The matrix must be square.");
    }

    public static int Trace(int[][] A) {
        if (Matrix.isSquare(A)) {
            int sum = 0;
            for (int i = 0; i < A.length; ++i) {
                sum += A[i][i];
            }
            return sum;
        }
        throw new IllegalArgumentException("The matrix must be square.");
    }

    public static float Trace(float[][] A) {
        if (Matrix.isSquare(A)) {
            float sum = 0.0f;
            for (int i = 0; i < A.length; ++i) {
                sum += A[i][i];
            }
            return sum;
        }
        throw new IllegalArgumentException("The matrix must be square.");
    }

    public static double[][] Transpose(double[][] A) {
        double[][] t = new double[A[0].length][A.length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                t[j][i] = A[i][j];
            }
        }
        return t;
    }

    public static int[][] Transpose(int[][] A) {
        int[][] t = new int[A[0].length][A.length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                t[j][i] = A[i][j];
            }
        }
        return t;
    }

    public static float[][] Transpose(float[][] A) {
        float[][] t = new float[A[0].length][A.length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                t[j][i] = A[i][j];
            }
        }
        return t;
    }

    public static <E> E[][] Transpose(E[][] A) {
        Object[][] t = (Object[][])Array.newInstance(A[0][0].getClass(), A[0].length, A.length);
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                t[j][i] = A[i][j];
            }
        }
        return t;
    }

    public static double[] UniformRandom(List<DoubleRange> ranges) {
        Random rand = new Random();
        double[] r = new double[ranges.size()];
        for (int i = 0; i < r.length; ++i) {
            DoubleRange range = ranges.get(i);
            r[i] = range.getMin() + rand.nextDouble() * (range.getMax() - range.getMin());
        }
        return r;
    }

    public static double[] UniformRandom(List<DoubleRange> ranges, long seed) {
        Random rand = new Random(seed);
        double[] r = new double[ranges.size()];
        for (int i = 0; i < r.length; ++i) {
            DoubleRange range = ranges.get(i);
            r[i] = range.getMin() + rand.nextDouble() * (range.getMax() - range.getMin());
        }
        return r;
    }

    public static double[] UniformRandom(DoubleRange range, int size) {
        return Matrix.UniformRandom(range.getMin(), range.getMax(), size);
    }

    public static double[] UniformRandom(double min, double max, int size) {
        Random rand = new Random();
        double[] r = new double[size];
        for (int i = 0; i < r.length; ++i) {
            r[i] = min + rand.nextDouble() * (max - min);
        }
        return r;
    }

    public static double[] UniformRandom(double min, double max, int size, long seed) {
        Random rand = new Random(seed);
        double[] r = new double[size];
        for (int i = 0; i < r.length; ++i) {
            r[i] = min + rand.nextDouble() * (max - min);
        }
        return r;
    }

    public static double[][] Identity(int order) {
        int i;
        order = Math.max(order, 2);
        double[][] matrix = new double[order][order];
        for (i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                matrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < order; ++i) {
            matrix[i][i] = 1.0;
        }
        return matrix;
    }

    public static double[][] Identity(int m, int n) {
        double[][] A = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return A;
    }

    public static double[][] Inverse(double[][] A) {
        return new LUDecomposition(A).inverse();
    }

    public static double[] Linspace(double min, double max, int points) {
        double[] v = new double[points];
        for (int i = 0; i < points; ++i) {
            v[i] = min + (double)i * (max - min) / (double)(points - 1);
        }
        return v;
    }

    public static double Max(double[][] matrix) {
        double max = -2.147483648E9;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                max = Math.max(max, matrix[i][j]);
            }
        }
        return max;
    }

    public static double Max(double[] matrix) {
        double max = -2.147483648E9;
        for (int i = 0; i < matrix.length; ++i) {
            max = Math.max(max, matrix[i]);
        }
        return max;
    }

    public static int Max(int[] matrix) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            max = Math.max(max, matrix[i]);
        }
        return max;
    }

    public static float Max(float[] matrix) {
        float max = -2.1474836E9f;
        for (int i = 0; i < matrix.length; ++i) {
            max = Math.max(max, matrix[i]);
        }
        return max;
    }

    public static int Max(int[][] matrix) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                max = Math.max(max, matrix[i][j]);
            }
        }
        return max;
    }

    public static float Max(float[][] matrix) {
        float max = -2.1474836E9f;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                max = Math.max(max, matrix[i][j]);
            }
        }
        return max;
    }

    public static int MaxIndex(double[] matrix) {
        int index = 0;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            double currentValue = Math.max(max, matrix[i]);
            if (!(currentValue > max)) continue;
            max = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MaxIndex(double[][] matrix) {
        IntPoint index = new IntPoint();
        double max = Double.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                double currentValue = Math.max(max, matrix[i][j]);
                if (!(currentValue > max)) continue;
                max = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static int MaxIndex(int[] matrix) {
        int index = 0;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            int currentValue = Math.max(max, matrix[i]);
            if (currentValue <= max) continue;
            max = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MaxIndex(int[][] matrix) {
        IntPoint index = new IntPoint();
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                int currentValue = Math.max(max, matrix[i][j]);
                if (currentValue <= max) continue;
                max = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static int MaxIndex(float[] matrix) {
        int index = 0;
        float max = Float.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            float currentValue = Math.max(max, matrix[i]);
            if (!(currentValue > max)) continue;
            max = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MaxIndex(float[][] matrix) {
        IntPoint index = new IntPoint();
        float max = Float.MIN_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                float currentValue = Math.max(max, matrix[i][j]);
                if (!(currentValue > max)) continue;
                max = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static double Mean(double[][] matrix) {
        double mean = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                mean += matrix[i][j];
            }
        }
        return mean /= (double)(matrix.length * matrix[0].length);
    }

    public static double Mean(int[][] matrix) {
        double mean = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                mean += (double)matrix[i][j];
            }
        }
        return mean /= (double)(matrix.length * matrix[0].length);
    }

    public static float Mean(float[][] matrix) {
        float mean = 0.0f;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                mean += matrix[i][j];
            }
        }
        return mean /= (float)(matrix.length * matrix[0].length);
    }

    public static int[][] MemberwiseClone(int[][] data) {
        int[][] clone = new int[data.length][];
        for (int i = 0; i < data.length; ++i) {
            clone[i] = (int[])data[i].clone();
        }
        return clone;
    }

    public static float[][] MemberwiseClone(float[][] data) {
        float[][] clone = new float[data.length][];
        for (int i = 0; i < data.length; ++i) {
            clone[i] = (float[])data[i].clone();
        }
        return clone;
    }

    public static double[][] MemberwiseClone(double[][] data) {
        double[][] clone = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            clone[i] = (double[])data[i].clone();
        }
        return clone;
    }

    public static double Min(double[] matrix) {
        double min = 2.147483647E9;
        for (int i = 0; i < matrix.length; ++i) {
            min = Math.min(min, matrix[i]);
        }
        return min;
    }

    public static double Min(double[][] matrix) {
        double min = 2.147483647E9;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
            }
        }
        return min;
    }

    public static int Min(int[] matrix) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            min = Math.min(min, matrix[i]);
        }
        return min;
    }

    public static float Min(float[] matrix) {
        float min = 2.1474836E9f;
        for (int i = 0; i < matrix.length; ++i) {
            min = Math.min(min, matrix[i]);
        }
        return min;
    }

    public static int Min(int[][] matrix) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
            }
        }
        return min;
    }

    public static float Min(float[][] matrix) {
        float min = 2.1474836E9f;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
            }
        }
        return min;
    }

    public static int MinIndex(double[] matrix) {
        int index = 0;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            double currentValue = Math.min(min, matrix[i]);
            if (!(currentValue < min)) continue;
            min = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MinIndex(double[][] matrix) {
        IntPoint index = new IntPoint();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                double currentValue = Math.min(min, matrix[i][j]);
                if (!(currentValue < min)) continue;
                min = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static double[] MinMax(double[][] matrix) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
                max = Math.max(max, matrix[i][j]);
            }
        }
        return new double[]{min, max};
    }

    public static int[] MinMax(int[][] matrix) {
        int min = Integer.MAX_VALUE;
        int max = -2147483647;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
                max = Math.max(max, matrix[i][j]);
            }
        }
        return new int[]{min, max};
    }

    public static float[] MinMax(float[][] matrix) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                min = Math.min(min, matrix[i][j]);
                max = Math.max(max, matrix[i][j]);
            }
        }
        return new float[]{min, max};
    }

    public static int MinIndex(int[] matrix) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            int currentValue = Math.min(min, matrix[i]);
            if (currentValue >= min) continue;
            min = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MinIndex(int[][] matrix) {
        IntPoint index = new IntPoint();
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                int currentValue = Math.min(min, matrix[i][j]);
                if (currentValue >= min) continue;
                min = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static int MinIndex(float[] matrix) {
        int index = 0;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            float currentValue = Math.min(min, matrix[i]);
            if (!(currentValue < min)) continue;
            min = currentValue;
            index = i;
        }
        return index;
    }

    public static IntPoint MinIndex(float[][] matrix) {
        IntPoint index = new IntPoint();
        float min = Float.MAX_VALUE;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                float currentValue = Math.min(min, matrix[i][j]);
                if (!(currentValue < min)) continue;
                min = currentValue;
                index.setXY(i, j);
            }
        }
        return index;
    }

    public static boolean isEqual(double[][] A, double[][] B) {
        if (A.length != B.length || A[0].length != B[0].length) {
            throw new IllegalArgumentException("The matrix A must be the same size of the B.");
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == B[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEqual(int[][] A, int[][] B) {
        if (A.length != B.length || A[0].length != B[0].length) {
            throw new IllegalArgumentException("The matrix A must be the same size of the B.");
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == B[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEqual(float[][] A, float[][] B) {
        if (A.length != B.length || A[0].length != B[0].length) {
            throw new IllegalArgumentException("The matrix A must be the same size of the B.");
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == B[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(double[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (!(A[i][j] < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(int[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(float[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (!(A[i][j] < 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(double[][] A) {
        return A.length * A.length == A.length * A[0].length;
    }

    public static boolean isSquare(int[][] A) {
        return A.length * A.length == A.length * A[0].length;
    }

    public static boolean isSquare(float[][] A) {
        return A.length * A.length == A.length * A[0].length;
    }

    public static boolean isSymmetric(double[][] A) {
        double[][] B = Matrix.Transpose(A);
        return Matrix.isEqual(A, B);
    }

    public static boolean isSymmetric(int[][] A) {
        int[][] B = Matrix.Transpose(A);
        return Matrix.isEqual(A, B);
    }

    public static boolean isSymmetric(float[][] A) {
        float[][] B = Matrix.Transpose(A);
        return Matrix.isEqual(A, B);
    }

    public static boolean isZero(int[] A) {
        for (int i = 0; i < A.length; ++i) {
            if (A[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(float[] A) {
        for (int i = 0; i < A.length; ++i) {
            if (A[i] == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(double[] A) {
        for (int i = 0; i < A.length; ++i) {
            if (A[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(float[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(double[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                if (A[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] RandomPermutation(int n) {
        int[] indexes = Matrix.Indices(0, n);
        ArraysUtil.Shuffle(indexes);
        return indexes;
    }

    public static int Rank(double[][] A) {
        SingularValueDecomposition svd = new SingularValueDecomposition(A, false, false);
        return svd.rank();
    }

    public static int Rank(int[][] A) {
        SingularValueDecomposition svd = new SingularValueDecomposition(ArraysUtil.toDouble(A), false, false);
        return svd.rank();
    }

    public static int Rank(float[][] A) {
        SingularValueDecomposition svd = new SingularValueDecomposition(ArraysUtil.toDouble(A), false, false);
        return svd.rank();
    }

    public static int[][] RemoveColumns(int[][] A, int[] index) {
        if (A[0].length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        int[][] B = new int[A.length][A[0].length - index.length];
        for (int i = 0; i < A.length; ++i) {
            int idx = index[0];
            int p = 0;
            int c = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == idx) {
                    if (p >= index.length - 1) continue;
                    idx = index[++p];
                    continue;
                }
                B[i][c++] = A[i][j];
            }
        }
        return B;
    }

    public static double[][] RemoveColumn(double[][] A, int index) {
        double[][] B = new double[A.length][A[0].length - 1];
        for (int i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == index) continue;
                B[i][idx] = A[i][j];
                ++idx;
            }
        }
        return B;
    }

    public static int[][] RemoveColumn(int[][] A, int index) {
        int[][] B = new int[A.length][A[0].length - 1];
        for (int i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == index) continue;
                B[i][idx] = A[i][j];
                ++idx;
            }
        }
        return B;
    }

    public static float[][] RemoveColumn(float[][] A, int index) {
        float[][] B = new float[A.length][A[0].length - 1];
        for (int i = 0; i < A.length; ++i) {
            int idx = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == index) continue;
                B[i][idx] = A[i][j];
                ++idx;
            }
        }
        return B;
    }

    public static double[][] RemoveColumns(double[][] A, int[] index) {
        if (A[0].length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        double[][] B = new double[A.length][A[0].length - index.length];
        for (int i = 0; i < A.length; ++i) {
            int idx = index[0];
            int p = 0;
            int c = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == idx) {
                    if (p >= index.length - 1) continue;
                    idx = index[++p];
                    continue;
                }
                B[i][c++] = A[i][j];
            }
        }
        return B;
    }

    public static float[][] RemoveColumns(float[][] A, int[] index) {
        if (A[0].length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        float[][] B = new float[A.length][A[0].length - index.length];
        for (int i = 0; i < A.length; ++i) {
            int idx = index[0];
            int p = 0;
            int c = 0;
            for (int j = 0; j < A[0].length; ++j) {
                if (j == idx) {
                    if (p >= index.length - 1) continue;
                    idx = index[++p];
                    continue;
                }
                B[i][c++] = A[i][j];
            }
        }
        return B;
    }

    public static double[] RemoveColumn(double[] A, int index) {
        if (A.length - index <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        double[] B = new double[A.length - 1];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            B[idx++] = A[i];
        }
        return B;
    }

    public static int[] RemoveColumn(int[] A, int index) {
        if (A.length - index <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        int[] B = new int[A.length - 1];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            B[idx++] = A[i];
        }
        return B;
    }

    public static float[] RemoveColumn(float[] A, int index) {
        if (A.length - index <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        float[] B = new float[A.length - 1];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            B[idx++] = A[i];
        }
        return B;
    }

    public static <T> T[] RemoveColumn(T[] A, int index) {
        if (A.length - index <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        Object[] B = (Object[])Array.newInstance(A[0].getClass(), A.length - 1);
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            B[idx++] = A[i];
        }
        return B;
    }

    public static double[] RemoveColumns(double[] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        double[] B = new double[A.length - index.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static int[] RemoveColumns(int[] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        int[] B = new int[A.length - index.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static float[] RemoveColumns(float[] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        float[] B = new float[A.length - index.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static double[] RemoveColumns(double[] A, List<Integer> index) {
        if (A.length - index.size() <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        double[] B = new double[A.length - index.size()];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.size(); ++j) {
                if (index.get(j) != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static int[] RemoveColumns(int[] A, List<Integer> index) {
        if (A.length - index.size() <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        int[] B = new int[A.length - index.size()];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.size(); ++j) {
                if (index.get(j) != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static float[] RemoveColumns(float[] A, List<Integer> index) {
        if (A.length - index.size() <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        float[] B = new float[A.length - index.size()];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.size(); ++j) {
                if (index.get(j) != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static boolean[] RemoveColumns(boolean[] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        boolean[] B = new boolean[A.length - index.length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static <T> T[] RemoveColumns(T[] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of columns is less or equal zero.");
        }
        Object[] B = (Object[])Array.newInstance(A[0].getClass(), A.length - index.length);
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            boolean has = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                has = true;
            }
            if (has) continue;
            B[idx] = A[i];
            ++idx;
        }
        return B;
    }

    public static double[][] RemoveRow(double[][] A, int index) {
        if (A.length - 1 <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        double[][] B = new double[A.length - 1][A[0].length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            System.arraycopy(A[i], 0, B[idx], 0, A[0].length);
            ++idx;
        }
        return B;
    }

    public static int[][] RemoveRow(int[][] A, int index) {
        if (A.length - 1 <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        int[][] B = new int[A.length - 1][A[0].length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            System.arraycopy(A[i], 0, B[idx], 0, A[0].length);
            ++idx;
        }
        return B;
    }

    public static float[][] RemoveRow(float[][] A, int index) {
        if (A.length - 1 <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        float[][] B = new float[A.length - 1][A[0].length];
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            System.arraycopy(A[i], 0, B[idx], 0, A[0].length);
            ++idx;
        }
        return B;
    }

    public static <T> T[][] RemoveRow(T[][] A, int index) {
        if (A.length - 1 <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        Object[][] B = (Object[][])Array.newInstance(A[0][0].getClass(), A.length - 1, A[0].length);
        int idx = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == index) continue;
            System.arraycopy(A[i], 0, B[idx], 0, A[0].length);
            ++idx;
        }
        return B;
    }

    public static int[][] RemoveRows(int[][] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        int[][] B = new int[A.length - index.length][A[0].length];
        int[] copy = Arrays.copyOf(index, index.length);
        Arrays.sort(copy);
        int idx = copy[0];
        int c = 0;
        int p = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == idx) {
                if (p >= index.length - 1) continue;
                idx = copy[++p];
                continue;
            }
            for (int j = 0; j < A[0].length; ++j) {
                B[c][j] = A[i][j];
            }
            ++c;
        }
        return B;
    }

    public static double[][] RemoveRows(double[][] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        int[] copy = Arrays.copyOf(index, index.length);
        Arrays.sort(copy);
        double[][] B = new double[A.length - index.length][A[0].length];
        int idx = copy[0];
        int c = 0;
        int p = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == idx) {
                if (p >= index.length - 1) continue;
                idx = copy[++p];
                continue;
            }
            for (int j = 0; j < A[0].length; ++j) {
                B[c][j] = A[i][j];
            }
            ++c;
        }
        return B;
    }

    public static float[][] RemoveRows(float[][] A, int[] index) {
        if (A.length - index.length <= 0) {
            throw new IllegalArgumentException("The number of rows is less or equal zero.");
        }
        int[] copy = Arrays.copyOf(index, index.length);
        Arrays.sort(copy);
        float[][] B = new float[A.length - index.length][A[0].length];
        int idx = copy[0];
        int c = 0;
        int p = 0;
        for (int i = 0; i < A.length; ++i) {
            if (i == idx) {
                if (p >= index.length - 1) continue;
                idx = copy[++p];
                continue;
            }
            for (int j = 0; j < A[0].length; ++j) {
                B[c][j] = A[i][j];
            }
            ++c;
        }
        return B;
    }

    public static double[][] Reshape(double[] vector, int m, int n) {
        if (vector.length != m * n) {
            throw new IllegalArgumentException("The size of vector must be the same of product of m and n.");
        }
        int x = 0;
        double[][] result = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = vector[x++];
            }
        }
        return result;
    }

    public static int[][] Reshape(int[] vector, int m, int n) {
        if (vector.length != m * n) {
            throw new IllegalArgumentException("The size of vector must be the same of product of m and n.");
        }
        int x = 0;
        int[][] result = new int[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = vector[x++];
            }
        }
        return result;
    }

    public static float[][] Reshape(float[] vector, int m, int n) {
        if (vector.length != m * n) {
            throw new IllegalArgumentException("The size of vector must be the same of product of m and n.");
        }
        int x = 0;
        float[][] result = new float[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = vector[x++];
            }
        }
        return result;
    }

    public static double[] Reshape(double[][] A) {
        double[] vector = new double[A.length * A[0].length];
        int x = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                vector[x++] = A[i][j];
            }
        }
        return vector;
    }

    public static int[] Reshape(int[][] A) {
        int[] vector = new int[A.length * A[0].length];
        int x = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                vector[x++] = A[i][j];
            }
        }
        return vector;
    }

    public static float[] Reshape(float[][] A) {
        float[] vector = new float[A.length * A[0].length];
        int x = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                vector[x++] = A[i][j];
            }
        }
        return vector;
    }

    public static double[][] SubMatrix(double[][] data, int rows, int cols) {
        double[][] m = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                m[i][j] = data[i][j];
            }
        }
        return m;
    }

    public static int[] SubMatrix(int[] data, int first) {
        if (first < 0 || first > data.length) {
            throw new IllegalArgumentException("first");
        }
        if (first == 0) {
            return data;
        }
        return Matrix.Submatrix(data, 0, first - 1);
    }

    public static double[] SubMatrix(double[] data, int first) {
        if (first < 0 || first > data.length) {
            throw new IllegalArgumentException("first");
        }
        if (first == 0) {
            return data;
        }
        return Matrix.Submatrix(data, 0, first - 1);
    }

    public static int[] Submatrix(int[] data, int startRow, int endRow) {
        if (startRow < 0) {
            throw new IllegalArgumentException("startRow");
        }
        if (endRow >= data.length) {
            throw new IllegalArgumentException("endRow");
        }
        int[] X = new int[endRow - startRow + 1];
        for (int i = startRow; i <= endRow; ++i) {
            X[i - startRow] = data[i];
        }
        return X;
    }

    public static double[] Submatrix(double[] data, int startRow, int endRow) {
        if (startRow < 0) {
            throw new IllegalArgumentException("startRow");
        }
        if (endRow >= data.length) {
            throw new IllegalArgumentException("endRow");
        }
        double[] X = new double[endRow - startRow + 1];
        for (int i = startRow; i <= endRow; ++i) {
            X[i - startRow] = data[i];
        }
        return X;
    }

    public static double[][] Submatrix(double[][] data, int startRow, int endRow, int startColumn, int endColumn) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        double[][] X = new double[endRow - startRow + 1][endColumn - startColumn + 1];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                X[i - startRow][j - startColumn] = data[i][j];
            }
        }
        return X;
    }

    public static int[][] Submatrix(int[][] data, int startRow, int endRow, int startColumn, int endColumn) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        int[][] X = new int[endRow - startRow + 1][endColumn - startColumn + 1];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                X[i - startRow][j - startColumn] = data[i][j];
            }
        }
        return X;
    }

    public static float[][] Submatrix(float[][] data, int startRow, int endRow, int startColumn, int endColumn) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        float[][] X = new float[endRow - startRow + 1][endColumn - startColumn + 1];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                X[i - startRow][j - startColumn] = data[i][j];
            }
        }
        return X;
    }

    public static double[][] Submatrix(double[][] data, int startRow, int endRow, int[] columnIndexes) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        if (columnIndexes == null) {
            columnIndexes = Matrix.Indices(0, data[0].length);
        }
        double[][] X = new double[endRow - startRow + 1][columnIndexes.length];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = 0; j < columnIndexes.length; ++j) {
                if (columnIndexes[j] < 0 || columnIndexes[j] >= data[0].length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i - startRow][j] = data[i][columnIndexes[j]];
            }
        }
        return X;
    }

    public static int[][] Submatrix(int[][] data, int startRow, int endRow, int[] columnIndexes) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        if (columnIndexes == null) {
            columnIndexes = Matrix.Indices(0, data[0].length);
        }
        int[][] X = new int[endRow - startRow + 1][columnIndexes.length];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = 0; j < columnIndexes.length; ++j) {
                if (columnIndexes[j] < 0 || columnIndexes[j] >= data[0].length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i - startRow][j] = data[i][columnIndexes[j]];
            }
        }
        return X;
    }

    public static float[][] Submatrix(float[][] data, int startRow, int endRow, int[] columnIndexes) {
        if (startRow > endRow || startRow < 0 || startRow >= data.length || endRow < 0 || endRow >= data.length) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        if (columnIndexes == null) {
            columnIndexes = Matrix.Indices(0, data[0].length);
        }
        float[][] X = new float[endRow - startRow + 1][columnIndexes.length];
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = 0; j < columnIndexes.length; ++j) {
                if (columnIndexes[j] < 0 || columnIndexes[j] >= data[0].length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i - startRow][j] = data[i][columnIndexes[j]];
            }
        }
        return X;
    }

    public static int[][] Submatrix(int[][] data, int[] rowIndexes) {
        int[][] X = new int[rowIndexes.length][data[0].length];
        for (int i = 0; i < rowIndexes.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (rowIndexes[i] < 0 || rowIndexes[i] >= data.length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i][j] = data[rowIndexes[i]][j];
            }
        }
        return X;
    }

    public static double[][] Submatrix(double[][] data, int[] rowIndexes) {
        double[][] X = new double[rowIndexes.length][data[0].length];
        for (int i = 0; i < rowIndexes.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (rowIndexes[i] < 0 || rowIndexes[i] >= data.length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i][j] = data[rowIndexes[i]][j];
            }
        }
        return X;
    }

    public static int[][] Submatrix(int[][] data, int[] rowIndexes, int startColumn, int endColumn) {
        int[][] X = new int[rowIndexes.length][endColumn - startColumn + 1];
        for (int i = 0; i < X.length; ++i) {
            for (int j = 0; j < X[0].length; ++j) {
                if (rowIndexes[i] < 0 || rowIndexes[i] >= data.length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i][j] = data[rowIndexes[i]][startColumn + j];
            }
        }
        return X;
    }

    public static double[][] Submatrix(double[][] data, int[] rowIndexes, int startColumn, int endColumn) {
        double[][] X = new double[rowIndexes.length][endColumn - startColumn + 1];
        for (int i = 0; i < X.length; ++i) {
            for (int j = 0; j < X[0].length; ++j) {
                if (rowIndexes[i] < 0 || rowIndexes[i] >= data.length) {
                    throw new IllegalArgumentException("Argument out of range.");
                }
                X[i][j] = data[rowIndexes[i]][startColumn + j];
            }
        }
        return X;
    }

    public static double[] toDoubleArray(int[][] A) {
        double[] m = new double[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static double[] toDoubleArray(double[][] A) {
        double[] m = new double[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static double[] toDoubleArray(float[][] A) {
        double[] m = new double[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static double[][] toDoubleMatrix(List<double[]> list) {
        double[][] m = new double[list.size()][list.get(0).length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = list.get(i);
        }
        return m;
    }

    public static int[] toIntArray(int[][] A) {
        int[] m = new int[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static int[] toIntArray(double[][] A) {
        int[] m = new int[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = (int)A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static int[] toIntArray(float[][] A) {
        int[] m = new int[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = (int)A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static int[][] toIntMatrix(List<int[]> list) {
        int[][] m = new int[list.size()][list.get(0).length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = list.get(i);
        }
        return m;
    }

    public static float[] toFloatArray(int[][] A) {
        float[] m = new float[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static float[] toFloatArray(double[][] A) {
        float[] m = new float[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = (float)A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static float[] toFloatArray(float[][] A) {
        float[] m = new float[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                m[index] = A[i][j];
                ++index;
            }
        }
        return m;
    }

    public static float[][] toFloatMatrix(List<float[]> list) {
        float[][] m = new float[list.size()][list.get(0).length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = list.get(i);
        }
        return m;
    }
}

