/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.FloatPoint;
import Catalano.Core.IntPoint;
import java.util.ArrayList;
import java.util.List;

public final class PointsCloud {
    private static float quadrilateralRelativeDistortionLimit = 0.1f;

    private PointsCloud() {
    }

    public static void Shift(ArrayList<IntPoint> cloud, IntPoint shift) {
        int n = cloud.size();
        for (int i = 0; i < n; ++i) {
            IntPoint p = cloud.get(i);
            p.Add(shift);
            cloud.set(i, p);
        }
    }

    public static List<IntPoint> GetBoundingRectangle(List<IntPoint> cloud) {
        ArrayList<IntPoint> bound = new ArrayList<IntPoint>();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (IntPoint pt : cloud) {
            int x = pt.x;
            int y = pt.y;
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (minX > maxX) {
            throw new IllegalArgumentException("List of points can not be empty.");
        }
        IntPoint min = new IntPoint(minX, minY);
        IntPoint max = new IntPoint(maxX, maxY);
        bound.add(min);
        bound.add(max);
        return bound;
    }

    public static FloatPoint GetCenterOfGravity(ArrayList<IntPoint> cloud) {
        int numberOfPoints = 0;
        float xSum = 0.0f;
        float ySum = 0.0f;
        for (IntPoint pt : cloud) {
            xSum += (float)pt.x;
            ySum += (float)pt.y;
            ++numberOfPoints;
        }
        return new FloatPoint(xSum /= (float)numberOfPoints, ySum /= (float)numberOfPoints);
    }

    public static FurthestPoint GetFurthestPoint(List<IntPoint> cloud, IntPoint referencePoint) {
        FurthestPoint furthestPoint = new FurthestPoint();
        float maxDistance = -1.0f;
        int rx = referencePoint.x;
        int ry = referencePoint.y;
        for (IntPoint point : cloud) {
            int dx = rx - point.x;
            int dy = ry - point.y;
            float distance = dx * dx + dy * dy;
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            furthestPoint.x = point.x;
            furthestPoint.y = point.y;
            furthestPoint.distance = maxDistance;
        }
        return furthestPoint;
    }

    public static FurthestPoint[] GetFurthestPointsFromLine(List<IntPoint> cloud, IntPoint linePoint1, IntPoint linePoint2) {
        FurthestPoint[] furthest = new FurthestPoint[]{new FurthestPoint(linePoint1), new FurthestPoint(linePoint2)};
        double distance1 = 0.0;
        double distance2 = 0.0;
        if (linePoint2.x != linePoint1.x) {
            float k = (float)(linePoint2.y - linePoint1.y) / (float)(linePoint2.x - linePoint1.x);
            float b = (float)linePoint1.y - k * (float)linePoint1.x;
            float div = (float)Math.sqrt(k * k + 1.0f);
            double distance = 0.0;
            for (IntPoint point : cloud) {
                distance = ((double)k * (double)point.x + (double)b - (double)point.y) / (double)div;
                if (distance > distance1) {
                    distance1 = distance;
                    furthest[0] = new FurthestPoint(point, (float)distance);
                }
                if (!(distance < distance2)) continue;
                distance2 = distance;
                furthest[1] = new FurthestPoint(point, (float)distance);
            }
        } else {
            int lineX = linePoint1.x;
            float distance = 0.0f;
            for (IntPoint point : cloud) {
                distance = lineX - point.x;
                if ((double)distance > distance1) {
                    distance1 = distance;
                    furthest[0] = new FurthestPoint(point, distance);
                }
                if (!((double)distance < distance2)) continue;
                distance2 = distance;
                furthest[1] = new FurthestPoint(point, distance);
            }
        }
        furthest[1].distance = (float)(-distance2);
        return furthest;
    }

    public static IntPoint GetFurthestPointFromLine(ArrayList<IntPoint> cloud, IntPoint linePoint1, IntPoint linePoint2) {
        IntPoint furthestPoint = linePoint1;
        float distance = 0.0f;
        if (linePoint2.x != linePoint1.x) {
            float k = (float)(linePoint2.y - linePoint1.y) / (float)(linePoint2.x - linePoint1.x);
            float b = (float)linePoint1.y - k * (float)linePoint1.x;
            float div = (float)Math.sqrt(k * k + 1.0f);
            float pointDistance = 0.0f;
            for (IntPoint point : cloud) {
                pointDistance = Math.abs((k * (float)point.x + b - (float)point.y) / div);
                if (!(pointDistance > distance)) continue;
                distance = pointDistance;
                furthestPoint = point;
            }
        } else {
            int lineX = linePoint1.x;
            float pointDistance = 0.0f;
            for (IntPoint point : cloud) {
                distance = Math.abs(lineX - point.x);
                if (!(pointDistance > distance)) continue;
                distance = pointDistance;
                furthestPoint = point;
            }
        }
        return furthestPoint;
    }

    public static float getQuadrilateralRelativeDistortionLimit() {
        return quadrilateralRelativeDistortionLimit;
    }

    public static void setQuadrilateralRelativeDistortionLimit(float value) {
        quadrilateralRelativeDistortionLimit = Math.max(0.0f, Math.min(0.25f, value));
    }

    public static List<IntPoint> FindQuadrilateralCorners(List<IntPoint> cloud) {
        float k2;
        float k1;
        ArrayList<IntPoint> corners = new ArrayList<IntPoint>();
        List<IntPoint> bounds = PointsCloud.GetBoundingRectangle(cloud);
        IntPoint minXY = bounds.get(0);
        IntPoint maxXY = bounds.get(1);
        IntPoint cloudSize = IntPoint.Subtract(maxXY, minXY);
        cloudSize.Divide(2);
        minXY.Add(cloudSize);
        IntPoint center = minXY;
        float distortionLimit = quadrilateralRelativeDistortionLimit * (float)(cloudSize.x + cloudSize.y) / 2.0f;
        IntPoint point1 = PointsCloud.GetFurthestPoint(cloud, center).toIntPoint();
        IntPoint point2 = PointsCloud.GetFurthestPoint(cloud, point1).toIntPoint();
        corners.add(point1);
        corners.add(point2);
        FurthestPoint[] fur = PointsCloud.GetFurthestPointsFromLine(cloud, point1, point2);
        IntPoint point3 = fur[0].toIntPoint();
        float distance3 = fur[0].distance;
        IntPoint point4 = fur[1].toIntPoint();
        float distance4 = fur[1].distance;
        if (distance3 >= distortionLimit && distance4 >= distortionLimit || distance3 < distortionLimit && distance3 != 0.0f && distance4 < distortionLimit && distance4 != 0.0f) {
            if (!corners.contains(point3)) {
                corners.add(point3);
            }
            if (!corners.contains(point4)) {
                corners.add(point4);
            }
        } else {
            IntPoint tempPoint = distance3 > distance4 ? point3 : point4;
            fur = PointsCloud.GetFurthestPointsFromLine(cloud, point1, tempPoint);
            point3 = fur[0].toIntPoint();
            distance3 = fur[0].distance;
            point4 = fur[1].toIntPoint();
            distance4 = fur[1].distance;
            boolean thirdPointIsFound = false;
            if (distance3 >= distortionLimit && distance4 >= distortionLimit) {
                if (point4.DistanceTo(point2) > point3.DistanceTo(point2)) {
                    point3 = point4;
                }
                thirdPointIsFound = true;
            } else {
                fur = PointsCloud.GetFurthestPointsFromLine(cloud, point2, tempPoint);
                point3 = fur[0].toIntPoint();
                distance3 = fur[0].distance;
                point4 = fur[1].toIntPoint();
                distance4 = fur[1].distance;
                if (distance3 >= distortionLimit && distance4 >= distortionLimit) {
                    if (point4.DistanceTo(point1) > point3.DistanceTo(point1)) {
                        point3 = point4;
                    }
                    thirdPointIsFound = true;
                }
            }
            if (!thirdPointIsFound) {
                corners.add(tempPoint);
            } else {
                corners.add(point3);
                fur = PointsCloud.GetFurthestPointsFromLine(cloud, point1, point3);
                tempPoint = fur[0].toIntPoint();
                float tempDistance = fur[0].distance;
                point4 = fur[1].toIntPoint();
                distance4 = fur[1].distance;
                if (distance4 >= distortionLimit && tempDistance >= distortionLimit) {
                    if (tempPoint.DistanceTo(point2) > point4.DistanceTo(point2)) {
                        point4 = tempPoint;
                    }
                } else {
                    fur = PointsCloud.GetFurthestPointsFromLine(cloud, point2, point3);
                    tempPoint = fur[0].toIntPoint();
                    tempDistance = fur[0].distance;
                    point4 = fur[1].toIntPoint();
                    distance4 = fur[1].distance;
                    if (tempPoint.DistanceTo(point1) > point4.DistanceTo(point1) && tempPoint != point2 && tempPoint != point3) {
                        point4 = tempPoint;
                    }
                }
                if (point4 != point1 && point4 != point2 && point4 != point3) {
                    corners.add(point4);
                }
            }
        }
        int n = corners.size();
        for (int i = 1; i < n; ++i) {
            if (((IntPoint)corners.get((int)i)).x >= ((IntPoint)corners.get((int)0)).x && (((IntPoint)corners.get((int)i)).x != ((IntPoint)corners.get((int)0)).x || ((IntPoint)corners.get((int)i)).y >= ((IntPoint)corners.get((int)0)).y)) continue;
            IntPoint temp = (IntPoint)corners.get(i);
            corners.set(i, (IntPoint)corners.get(0));
            corners.set(0, temp);
        }
        float f = ((IntPoint)corners.get((int)1)).x != ((IntPoint)corners.get((int)0)).x ? (float)(((IntPoint)corners.get((int)1)).y - ((IntPoint)corners.get((int)0)).y) / (float)(((IntPoint)corners.get((int)1)).x - ((IntPoint)corners.get((int)0)).x) : (k1 = ((IntPoint)corners.get((int)1)).y > ((IntPoint)corners.get((int)0)).y ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
        float f2 = ((IntPoint)corners.get((int)2)).x != ((IntPoint)corners.get((int)0)).x ? (float)(((IntPoint)corners.get((int)2)).y - ((IntPoint)corners.get((int)0)).y) / (float)(((IntPoint)corners.get((int)2)).x - ((IntPoint)corners.get((int)0)).x) : (k2 = ((IntPoint)corners.get((int)2)).y > ((IntPoint)corners.get((int)0)).y ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
        if (k2 < k1) {
            IntPoint temp = (IntPoint)corners.get(1);
            corners.set(1, (IntPoint)corners.get(2));
            corners.set(2, temp);
            float tk = k1;
            k1 = k2;
            k2 = tk;
        }
        if (corners.size() == 4) {
            float tk;
            float k3;
            float f3 = ((IntPoint)corners.get((int)3)).x != ((IntPoint)corners.get((int)0)).x ? (float)(((IntPoint)corners.get((int)3)).y - ((IntPoint)corners.get((int)0)).y) / (float)(((IntPoint)corners.get((int)3)).x - ((IntPoint)corners.get((int)0)).x) : (k3 = ((IntPoint)corners.get((int)3)).y > ((IntPoint)corners.get((int)0)).y ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            if (k3 < k1) {
                IntPoint temp = (IntPoint)corners.get(1);
                corners.set(1, (IntPoint)corners.get(3));
                corners.set(3, temp);
                tk = k1;
                k1 = k3;
                k3 = tk;
            }
            if (k3 < k2) {
                IntPoint temp = (IntPoint)corners.get(2);
                corners.set(2, (IntPoint)corners.get(3));
                corners.set(3, temp);
                tk = k2;
                k2 = k3;
                k3 = tk;
            }
        }
        return corners;
    }

    public static class FurthestPoint {
        public int x;
        public int y;
        public float distance;

        public FurthestPoint() {
        }

        public FurthestPoint(int x, int y, float distance) {
            this.x = x;
            this.y = y;
            this.distance = distance;
        }

        public FurthestPoint(IntPoint p) {
            this.x = p.x;
            this.y = p.y;
        }

        public FurthestPoint(IntPoint p, float distance) {
            this.x = p.x;
            this.y = p.y;
            this.distance = distance;
        }

        public IntPoint toIntPoint() {
            return new IntPoint(this.x, this.y);
        }
    }
}

