/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import Catalano.Math.ComplexNumber;
import Catalano.Math.Geometry.IShapeOptimizer;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.List;

public class DiscreteCurveEvolution
implements IShapeOptimizer {
    private int vertices;

    public DiscreteCurveEvolution() {
        this(20);
    }

    public DiscreteCurveEvolution(int vertices) {
        this.vertices = vertices;
    }

    @Override
    public List<IntPoint> OptimizeShape(List<IntPoint> shape) {
        int i;
        if (this.vertices > shape.size()) {
            throw new IllegalArgumentException("Number of points left must be higher than number of the shape.");
        }
        ArrayList<ComplexNumber> complex = new ArrayList<ComplexNumber>();
        for (i = 0; i < shape.size(); ++i) {
            complex.add(new ComplexNumber(shape.get((int)i).x, shape.get((int)i).y));
        }
        for (i = 0; i < shape.size() - this.vertices; ++i) {
            double[] winkelmaass = this.winkel(complex);
            int index = Matrix.MinIndex(winkelmaass);
            complex.remove(index);
        }
        ArrayList<IntPoint> newShape = new ArrayList<IntPoint>(complex.size());
        for (int i2 = 0; i2 < complex.size(); ++i2) {
            newShape.add(new IntPoint((int)complex.get((int)i2).real, (int)complex.get((int)i2).imaginary));
        }
        return newShape;
    }

    private double[] winkel(ArrayList<ComplexNumber> z) {
        int n = z.size();
        double max = -1.7976931348623157E308;
        double[] his = new double[n];
        for (int j = 1; j < n - 1; ++j) {
            ComplexNumber c = ComplexNumber.Subtract(z.get(j - 1), z.get(j + 1));
            double lm = c.getMagnitude();
            c = ComplexNumber.Subtract(z.get(j), z.get(j + 1));
            double lr = c.getMagnitude();
            c = ComplexNumber.Subtract(z.get(j - 1), z.get(j));
            double ll = c.getMagnitude();
            double alpha = Math.acos((lr * lr + ll * ll - lm * lm) / (2.0 * lr * ll));
            double a = 180.0 - alpha * 180.0 / Math.PI;
            his[j] = a * lr * ll / (lr + ll);
            if (!(his[j] > max)) continue;
            max = his[j];
        }
        his[0] = max;
        his[n - 1] = max;
        return his;
    }
}

