/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

public class PerlinNoise {
    private double initFrequency = 1.0;
    private double initAmplitude = 1.0;
    private double persistence = 0.65;
    private int octaves = 4;

    public PerlinNoise() {
    }

    public PerlinNoise(int octaves, double persistense) {
        this.octaves = octaves;
        this.persistence = persistense;
    }

    public PerlinNoise(int octaves, double persistence, double initFrequency, double initAmplitude) {
        this.octaves = octaves;
        this.persistence = persistence;
        this.initFrequency = initFrequency;
        this.initAmplitude = initAmplitude;
    }

    public double getInitAmplitude() {
        return this.initAmplitude;
    }

    public void setInitAmplitude(double initAmplitude) {
        this.initAmplitude = initAmplitude;
    }

    public double getInitFrequency() {
        return this.initFrequency;
    }

    public void setInitFrequency(double initFrequency) {
        this.initFrequency = initFrequency;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int octaves) {
        this.octaves = octaves;
    }

    public double getPersistence() {
        return this.persistence;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
    }

    public double Function1D(double x) {
        double frequency = this.initFrequency;
        double amplitude = this.initAmplitude;
        double sum = 0.0;
        for (int i = 0; i < this.octaves; ++i) {
            sum += this.SmoothedNoise(x * frequency) * amplitude;
            frequency *= 2.0;
            amplitude *= this.persistence;
        }
        return sum;
    }

    public double Function2D(double x, double y) {
        double frequency = this.initFrequency;
        double amplitude = this.initAmplitude;
        double sum = 0.0;
        for (int i = 0; i < this.octaves; ++i) {
            sum += this.SmoothedNoise(x * frequency, y * frequency) * amplitude;
            frequency *= 2.0;
            amplitude *= this.persistence;
        }
        return sum;
    }

    private double Noise(int x) {
        int n = x << 13 ^ x;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    private double Noise(int x, int y) {
        int n = x + y * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    private double SmoothedNoise(double x) {
        int xInt = (int)x;
        double xFrac = x - (double)xInt;
        return this.CosineInterpolate(this.Noise(xInt), this.Noise(xInt + 1), xFrac);
    }

    private double SmoothedNoise(double x, double y) {
        int xInt = (int)x;
        int yInt = (int)y;
        double xFrac = x - (double)xInt;
        double yFrac = y - (double)yInt;
        double x0y0 = this.Noise(xInt, yInt);
        double x1y0 = this.Noise(xInt + 1, yInt);
        double x0y1 = this.Noise(xInt, yInt + 1);
        double x1y1 = this.Noise(xInt + 1, yInt + 1);
        double v1 = this.CosineInterpolate(x0y0, x1y0, xFrac);
        double v2 = this.CosineInterpolate(x0y1, x1y1, xFrac);
        return this.CosineInterpolate(v1, v2, yFrac);
    }

    private double CosineInterpolate(double x1, double x2, double a) {
        double f = (1.0 - Math.cos(a * Math.PI)) * 0.5;
        return x1 * (1.0 - f) + x2 * f;
    }
}

