/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

import Catalano.Math.Special;

public final class Gamma {
    public static final double GammaMax = 171.6243769563027;

    private Gamma() {
    }

    public static double Function(double x) {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double z;
                double p = Math.floor(q);
                if (p == q) {
                    try {
                        throw new ArithmeticException("Overflow");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((z = q - p) > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    try {
                        throw new ArithmeticException("Overflow");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                z = Math.abs(z);
                z = Math.PI / (z * Gamma.Stirling(q));
                return -z;
            }
            return Gamma.Stirling(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException();
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException();
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Special.Polevl(x -= 2.0, P, 6);
        q = Special.Polevl(x, Q, 7);
        return z * p / q;
    }

    public static double LowerIncomplete(double a, double x) {
        double eps = 1.0E-15;
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        if (a < 0.0) {
            try {
                throw new IllegalArgumentException("Out of Range: a");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (x < 0.0) {
            try {
                throw new IllegalArgumentException("Out of Range: x");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (a == 0.0) {
            if (x == 0.0) {
                return Double.NaN;
            }
            return 1.0;
        }
        if (x == 0.0) {
            return 0.0;
        }
        double ax = a * Math.log(x) - x - Gamma.Log(a);
        if (ax < -709.782712893384) {
            return 1.0;
        }
        if (x <= 1.0 || x <= a) {
            double r2 = a;
            double c2 = 1.0;
            double ans2 = 1.0;
            while ((c2 = c2 * x / (r2 += 1.0)) / (ans2 += c2) > 1.0E-15) {
            }
            return Math.exp(ax) * ans2 / a;
        }
        int c = 0;
        double y = 1.0 - a;
        double z = x + y + 1.0;
        double p3 = 1.0;
        double q3 = x;
        double p2 = x + 1.0;
        double q2 = z * x;
        double ans = p2 / q2;
        double error = 0.0;
        do {
            double yc = (y += 1.0) * (double)(++c);
            double p = p2 * (z += 2.0) - p3 * yc;
            double q = q2 * z - q3 * yc;
            if (q != 0.0) {
                double nextans = p / q;
                error = Math.abs((ans - nextans) / nextans);
                ans = nextans;
            } else {
                error = 1.0;
            }
            p3 = p2;
            p2 = p;
            q3 = q2;
            q2 = q;
            if (!(Math.abs(p) > 4.503599627370496E15)) continue;
            p3 *= 2.220446049250313E-16;
            p2 *= 2.220446049250313E-16;
            q3 *= 2.220446049250313E-16;
            q2 *= 2.220446049250313E-16;
        } while (error > 1.0E-15);
        return 1.0 - Math.exp(ax) * ans;
    }

    public static double Stirling(double x) {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Special.Polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    public static double Digamma(double x) {
        double s = 0.0;
        double w = 0.0;
        double y = 0.0;
        double z = 0.0;
        double nz = 0.0;
        boolean negative = false;
        if (x <= 0.0) {
            negative = true;
            double q = x;
            double p = (int)Math.floor(q);
            if (p == q) {
                try {
                    throw new ArithmeticException("Function computation resulted in arithmetic overflow.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((nz = q - p) != 0.5) {
                if (nz > 0.5) {
                    nz = q - (p += 1.0);
                }
                nz = Math.PI / Math.tan(Math.PI * nz);
            } else {
                nz = 0.0;
            }
            x = 1.0 - x;
        }
        if (x <= 10.0 && x == Math.floor(x)) {
            y = 0.0;
            int n = (int)Math.floor(x);
            for (int i = 1; i <= n - 1; ++i) {
                w = i;
                y += 1.0 / w;
            }
            y -= 0.5772156649015329;
        } else {
            w = 0.0;
            for (s = x; s < 10.0; s += 1.0) {
                w += 1.0 / s;
            }
            if (s < 1.0E17) {
                z = 1.0 / (s * s);
                double polv = 0.08333333333333333;
                polv = polv * z - 0.021092796092796094;
                polv = polv * z + 0.007575757575757576;
                polv = polv * z - 0.004166666666666667;
                polv = polv * z + 0.003968253968253968;
                polv = polv * z - 0.008333333333333333;
                polv = polv * z + 0.08333333333333333;
                y = z * polv;
            } else {
                y = 0.0;
            }
            y = Math.log(s) - 0.5 / s - y - w;
        }
        if (negative) {
            y -= nz;
        }
        return y;
    }

    public static double ComplementedIncomplete(double a, double x) {
        double t;
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        if (x <= 0.0 || a <= 0.0) {
            return 1.0;
        }
        if (x < 1.0 || x < a) {
            return 1.0 - Gamma.Incomplete(a, x);
        }
        double ax = a * Math.log(x) - x - Gamma.Log(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double y = 1.0 - a;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > 4.503599627370496E15)) continue;
            pkm2 *= 2.220446049250313E-16;
            pkm1 *= 2.220446049250313E-16;
            qkm2 *= 2.220446049250313E-16;
            qkm1 *= 2.220446049250313E-16;
        } while (t > (double)1.110223E-16f);
        return ans * ax;
    }

    public static double Incomplete(double a, double x) {
        if (x <= 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x > 1.0 && x > a) {
            return 1.0 - Gamma.ComplementedIncomplete(a, x);
        }
        double ax = a * Math.log(x) - x - Gamma.Log(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double r = a;
        double c = 1.0;
        double ans = 1.0;
        while ((c *= x / (r += 1.0)) / (ans += c) > (double)1.110223E-16f) {
        }
        return ans * ax / a;
    }

    public static double Log(double x) {
        double[] A = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double z;
            double q = -x;
            double w = Gamma.Log(q);
            double p = Math.floor(q);
            if (p == q) {
                try {
                    throw new ArithmeticException("Overflow.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((z = q - p) > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                try {
                    throw new ArithmeticException("Overflow.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    try {
                        throw new ArithmeticException("Overflow.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Special.Polevl(x, B, 5) / Special.P1evl(x, C, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            try {
                throw new ArithmeticException("Overflow.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Special.Polevl(p, A, 4) / x);
        return q;
    }
}

