/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;

public class PiecewiseMap
implements IChaoticFunction {
    private double p;

    public PiecewiseMap() {
        this(0.4);
    }

    public PiecewiseMap(double p) {
        this.p = p;
    }

    @Override
    public double Generate(double x) {
        if (x >= 0.0 && x < this.p) {
            return x / this.p;
        }
        if (x >= this.p && x < 0.5) {
            return (x - this.p) / (0.5 - this.p);
        }
        if (x >= 0.5 && x < 1.0 - this.p) {
            return (1.0 - this.p - x) / (0.5 - this.p);
        }
        return (1.0 - x) / this.p;
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

