/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;

public class CircleMap
implements IChaoticFunction {
    private double a;
    private double b;

    public CircleMap() {
        this(0.5, 0.2);
    }

    public CircleMap(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double Generate(double x) {
        double r = x + this.b - this.a / (Math.PI * 2) * Math.sin(Math.PI * 2 * x);
        return r % 1.0;
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

