/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

import Catalano.Math.Functions.Gamma;

public final class Beta {
    private Beta() {
    }

    public static double Function(double a, double b) {
        return Math.exp(Beta.Log(a, b));
    }

    public static double Log(double a, double b) {
        return Gamma.Log(a) + Gamma.Log(b) - Gamma.Log(a + b);
    }

    public static double Incomplete(double a, double b, double x) {
        double xx;
        double xc;
        double bb;
        double aa;
        if (a <= 0.0) {
            try {
                throw new IllegalArgumentException(" 'a' Lower limit must be greater than zero.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (b <= 0.0) {
            try {
                throw new IllegalArgumentException(" 'b' Upper limit must be greater than zero.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (x <= 0.0 || x >= 1.0) {
            if (x == 0.0) {
                return 0.0;
            }
            if (x == 1.0) {
                return 1.0;
            }
            try {
                throw new IllegalArgumentException(" 'x' Value must be between 0 and 1.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean flag = false;
        if (b * x <= 1.0 && x <= 0.95) {
            double t = Beta.PowerSeries(a, b, x);
            return t;
        }
        double w = 1.0 - x;
        if (x > a / (a + b)) {
            flag = true;
            aa = b;
            bb = a;
            xc = x;
            xx = w;
        } else {
            aa = a;
            bb = b;
            xc = w;
            xx = x;
        }
        if (flag && bb * xx <= 1.0 && xx <= 0.95) {
            double t = Beta.PowerSeries(aa, bb, xx);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = xx * (aa + bb - 2.0) - (aa - 1.0);
        w = y < 0.0 ? Beta.Incbcf(aa, bb, xx) : Beta.Incbd(aa, bb, xx) / xc;
        y = aa * Math.log(xx);
        double t = bb * Math.log(xc);
        if (aa + bb < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, bb);
            t *= Math.pow(xx, aa);
            t /= aa;
            t *= w;
            t *= Gamma.Function(aa + bb) / (Gamma.Function(aa) * Gamma.Function(bb));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + Gamma.Log(aa + bb) - Gamma.Log(aa) - Gamma.Log(bb);
        t = (y += Math.log(w / aa)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    public static double Incbcf(double a, double b, double x) {
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > big) {
                pkm2 *= biginv;
                pkm1 *= biginv;
                qkm2 *= biginv;
                qkm1 *= biginv;
            }
            if (!(Math.abs(qk) < biginv) && !(Math.abs(pk) < biginv)) continue;
            pkm2 *= big;
            pkm1 *= big;
            qkm2 *= big;
            qkm1 *= big;
        } while (++n < 300);
        return ans;
    }

    public static double Incbd(double a, double b, double x) {
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > big) {
                pkm2 *= biginv;
                pkm1 *= biginv;
                qkm2 *= biginv;
                qkm1 *= biginv;
            }
            if (!(Math.abs(qk) < biginv) && !(Math.abs(pk) < biginv)) continue;
            pkm2 *= big;
            pkm1 *= big;
            qkm2 *= big;
            qkm1 *= big;
        } while (++n < 300);
        return ans;
    }

    public static double PowerSeries(double a, double b, double x) {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = Gamma.Function(a + b) / (Gamma.Function(a) * Gamma.Function(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = Gamma.Log(a + b) - Gamma.Log(a) - Gamma.Log(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }
}

