/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

public final class Bessel {
    private Bessel() {
    }

    public static double J0(double x) {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = 5.7568490574E10 + y * (-1.3362590354E10 + y * (6.516196407E8 + y * (-1.121442418E7 + y * (77392.33017 + y * -184.9052456))));
            double ans2 = 5.7568490411E10 + y * (1.029532985E9 + y * (9494680.718 + y * (59272.64853 + y * (267.8532712 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double y = z * z;
        double xx = ax - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 - y * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
    }

    public static double J(double x) {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = x * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double xx = ax - 2.356194491;
        double y = z * z;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        double ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        if (x < 0.0) {
            ans = -ans;
        }
        return ans;
    }

    public static double J(int n, double x) {
        double ans;
        double ACC = 40.0;
        double BIGNO = 1.0E10;
        double BIGNI = 1.0E-10;
        if (n == 0) {
            return Bessel.J0(x);
        }
        if (n == 1) {
            return Bessel.J(x);
        }
        double ax = Math.abs(x);
        if (ax == 0.0) {
            return 0.0;
        }
        if (ax > (double)n) {
            double tox = 2.0 / ax;
            double bjm = Bessel.J0(ax);
            double bj = Bessel.J(ax);
            for (int j = 1; j < n; ++j) {
                double bjp = (double)j * tox * bj - bjm;
                bjm = bj;
                bj = bjp;
            }
            ans = bj;
        } else {
            double tox = 2.0 / ax;
            int m = 2 * ((n + (int)Math.sqrt(ACC * (double)n)) / 2);
            boolean jsum = false;
            double sum = 0.0;
            ans = 0.0;
            double bjp = 0.0;
            double bj = 1.0;
            for (int j = m; j > 0; --j) {
                double bjm = (double)j * tox * bj - bjp;
                bjp = bj;
                bj = bjm;
                if (Math.abs(bj) > BIGNO) {
                    bj *= BIGNI;
                    bjp *= BIGNI;
                    ans *= BIGNI;
                    sum *= BIGNI;
                }
                if (jsum) {
                    sum += bj;
                }
                boolean bl = jsum = !jsum;
                if (j != n) continue;
                ans = bjp;
            }
            sum = 2.0 * sum - bj;
            ans /= sum;
        }
        return x < 0.0 && n % 2 == 1 ? -ans : ans;
    }

    public static double Y0(double x) {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = -2.957821389E9 + y * (7.062834065E9 + y * (-5.123598036E8 + y * (1.087988129E7 + y * (-86327.92757 + y * 228.4622733))));
            double ans2 = 4.0076544269E10 + y * (7.452499648E8 + y * (7189466.438 + y * (47447.2647 + y * (226.1030244 + y * 1.0))));
            return ans1 / ans2 + 0.636619772 * Bessel.J0(x) * Math.log(x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 + y * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double Y(double x) {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = x * (-4.900604943E12 + y * (1.27527439E12 + y * (-5.153438139E10 + y * (7.349264551E8 + y * (-4237922.726 + y * 8511.937935)))));
            double ans2 = 2.49958057E13 + y * (4.244419664E11 + y * (3.733650367E9 + y * (2.245904002E7 + y * (102042.605 + y * (354.9632885 + y)))));
            return ans1 / ans2 + 0.636619772 * (Bessel.J(x) * Math.log(x) - 1.0 / x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 2.356194491;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double Y(int n, double x) {
        if (n == 0) {
            return Bessel.Y0(x);
        }
        if (n == 1) {
            return Bessel.Y(x);
        }
        double tox = 2.0 / x;
        double by = Bessel.Y(x);
        double bym = Bessel.Y0(x);
        for (int j = 1; j < n; ++j) {
            double byp = (double)j * tox * by - bym;
            bym = by;
            by = byp;
        }
        return by;
    }

    public static double I0(double x) {
        double ans;
        double ax = Math.abs(x);
        if (ax < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = 1.0 + y * (3.5156229 + y * (3.0899424 + y * (1.2067492 + y * (0.2659732 + y * (0.0360768 + y * 0.0045813)))));
        } else {
            double y = 3.75 / ax;
            ans = Math.exp(ax) / Math.sqrt(ax) * (0.39894228 + y * (0.01328592 + y * (0.00225319 + y * (-0.00157565 + y * (0.00916281 + y * (-0.02057706 + y * (0.02635537 + y * (-0.01647633 + y * 0.00392377))))))));
        }
        return ans;
    }

    public static double I(double x) {
        double ans;
        double ax = Math.abs(x);
        if (ax < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = ax * (0.5 + y * (0.87890594 + y * (0.51498869 + y * (0.15084934 + y * (0.02658733 + y * (0.00301532 + y * 3.2411E-4))))));
        } else {
            double y = 3.75 / ax;
            ans = 0.02282967 + y * (-0.02895312 + y * (0.01787654 - y * 0.00420059));
            ans = 0.39894228 + y * (-0.03988024 + y * (-0.00362018 + y * (0.00163801 + y * (-0.01031555 + y * ans))));
            ans *= Math.exp(ax) / Math.sqrt(ax);
        }
        return x < 0.0 ? -ans : ans;
    }

    public static double I(int n, double x) {
        if (n < 0) {
            throw new IllegalArgumentException("the variable n out of range.");
        }
        if (n == 0) {
            return Bessel.I0(x);
        }
        if (n == 1) {
            return Bessel.I(x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        double ACC = 40.0;
        double BIGNO = 1.0E10;
        double BIGNI = 1.0E-10;
        double tox = 2.0 / Math.abs(x);
        double bip = 0.0;
        double ans = 0.0;
        double bi = 1.0;
        for (int j = 2 * (n + (int)Math.sqrt(ACC * (double)n)); j > 0; --j) {
            double bim = bip + (double)j * tox * bi;
            bip = bi;
            bi = bim;
            if (Math.abs(bi) > BIGNO) {
                ans *= BIGNI;
                bi *= BIGNI;
                bip *= BIGNI;
            }
            if (j != n) continue;
            ans = bip;
        }
        return x < 0.0 && n % 2 == 1 ? -ans : (ans *= Bessel.I0(x) / bi);
    }
}

