/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.Math.Distances.IDivergence;
import Catalano.Math.Distances.SquaredEuclideanDistance;
import Catalano.Math.Tools;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class RadiusNearestNeighbors
implements IRegression,
Serializable {
    private double radius;
    private double[][] input;
    private double[] output;
    private IDivergence divergence;
    private IMercerKernel kernel;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public RadiusNearestNeighbors() {
        this(0.2);
    }

    public RadiusNearestNeighbors(double radius) {
        this(0.2, new SquaredEuclideanDistance());
    }

    public RadiusNearestNeighbors(double radius, IDivergence divergence) {
        this.radius = radius;
        this.divergence = divergence;
    }

    public RadiusNearestNeighbors(double radius, IMercerKernel kernel) {
        this.radius = radius;
        this.kernel = kernel;
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public double Predict(double[] feature) {
        double[] temp;
        int i;
        double[] dist = new double[this.input.length];
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        if (this.kernel == null) {
            for (i = 0; i < this.input.length; ++i) {
                temp = this.input[i];
                dist[i] = this.divergence.Compute(temp, feature);
                max = Math.max(max, dist[i]);
                min = Math.min(min, dist[i]);
            }
        } else {
            for (i = 0; i < this.input.length; ++i) {
                temp = this.input[i];
                dist[i] = this.kernel.Function(temp, feature);
                max = Math.max(max, dist[i]);
                min = Math.min(min, dist[i]);
            }
        }
        for (i = 0; i < dist.length; ++i) {
            dist[i] = Tools.Scale(min, max, 0.0, 1.0, dist[i]);
        }
        int[] indexes = ArraysUtil.Argsort(dist, true);
        int k = this.Min(dist, indexes);
        double result = 0.0;
        for (int i2 = 0; i2 < k; ++i2) {
            result += this.output[indexes[i2]];
        }
        return result / (double)k;
    }

    private int Min(double[] dist, int[] indexes) {
        int e = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (dist[indexes[i]] > this.radius) {
                return e;
            }
            ++e;
        }
        return e;
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }
}

