/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureSelection;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Classification.DecisionTrees.Learning.RandomForest;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.FeatureSelection.ISupervisionedFeatureSelection;

public class RandomForestFeatureSelection
implements ISupervisionedFeatureSelection {
    private double[] rank;
    private int[] features;

    @Override
    public void Compute(DatasetClassification dataset) {
        this.Compute(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Compute(double[][] input, int[] labels) {
        RandomForest rf = new RandomForest();
        rf.Learn(input, labels);
        this.rank = rf.importance();
        this.features = ArraysUtil.Argsort(this.rank, false);
    }

    @Override
    public int[] getFeatureIndex() {
        return this.features;
    }

    @Override
    public double[] getRank() {
        return this.rank;
    }
}

