/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.ArraysUtil;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.IAggregateVectors;
import Catalano.Imaging.Tools.SpatialHistogram;
import java.util.ArrayList;

public class SpatialPyramidHistogram {
    private int level;

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Math.max(1, level);
    }

    public SpatialPyramidHistogram() {
        this(3);
    }

    public SpatialPyramidHistogram(int level) {
        this.setLevel(level);
    }

    public int[] Compute(FastBitmap fastBitmap, IBinaryPattern pattern) {
        ArrayList<int[]> histograms = new ArrayList<int[]>();
        int elem = 0;
        int size = 1;
        for (int i = 0; i < this.level; ++i) {
            SpatialHistogram sh = new SpatialHistogram(size, size);
            histograms.add(sh.Compute(fastBitmap, pattern));
            elem += ((int[])histograms.get(i)).length;
            size *= 2;
        }
        int[] all = new int[elem];
        int idx = 0;
        for (int i = 0; i < histograms.size(); ++i) {
            int[] h = (int[])histograms.get(i);
            for (int j = 0; j < h.length; ++j) {
                all[idx++] = h[j];
            }
        }
        return all;
    }

    public double[] Compute(FastBitmap fastBitmap, IAggregateVectors features) {
        ArrayList<double[]> lst = new ArrayList<double[]>();
        int size = 1;
        for (int i = 0; i < this.level; ++i) {
            SpatialHistogram sh = new SpatialHistogram(size, size);
            lst.add(sh.Compute(fastBitmap, features));
            size *= 2;
        }
        return ArraysUtil.ConcatenateDouble(lst);
    }
}

