/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.ArraysUtil;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Crop;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.IAggregateVectors;
import Catalano.Imaging.Tools.ImageHistogram;
import java.util.ArrayList;

public class SpatialHistogram {
    private int wBlock;
    private int hBlock;

    public SpatialHistogram() {
        this(6, 6);
    }

    public SpatialHistogram(int wBlock, int hBlock) {
        this.wBlock = wBlock;
        this.hBlock = hBlock;
    }

    public int[] Compute(FastBitmap fastBitmap, IBinaryPattern pattern) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int wDiv = (int)Math.round((double)width / (double)this.wBlock) - 1;
        int hDiv = (int)Math.round((double)height / (double)this.hBlock) - 1;
        ImageHistogram[] hist = new ImageHistogram[this.wBlock * this.hBlock];
        int idx = 0;
        for (int i = 0; i < this.hBlock; ++i) {
            for (int j = 0; j < this.wBlock; ++j) {
                FastBitmap copy = this.getSubimage(fastBitmap, i * hDiv, j * wDiv, wDiv, hDiv);
                hist[idx++] = pattern.ComputeFeatures(copy);
            }
        }
        int[] all = new int[hist.length * hist[0].getValues().length];
        idx = 0;
        for (int i = 0; i < hist.length; ++i) {
            int[] values = hist[i].getValues();
            for (int j = 0; j < values.length; ++j) {
                all[idx++] = values[j];
            }
        }
        return all;
    }

    public double[] Compute(FastBitmap fastBitmap, IAggregateVectors features) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int wDiv = (int)Math.round((double)width / (double)this.wBlock) - 1;
        int hDiv = (int)Math.round((double)height / (double)this.hBlock) - 1;
        ArrayList<double[]> lst = new ArrayList<double[]>();
        for (int i = 0; i < this.hBlock; ++i) {
            for (int j = 0; j < this.wBlock; ++j) {
                FastBitmap copy = this.getSubimage(fastBitmap, i * hDiv, j * wDiv, wDiv, hDiv);
                lst.add(features.Compute(copy));
            }
        }
        return ArraysUtil.ConcatenateDouble(lst);
    }

    private FastBitmap getSubimage(FastBitmap fastBitmap, int x, int y, int width, int height) {
        FastBitmap copy = new FastBitmap(fastBitmap);
        Crop crop = new Crop(x, y, width, height);
        crop.applyInPlace(copy);
        return copy;
    }
}

