/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IProcessImage;
import Catalano.Math.Geometry.QuadrilateralTransformationCalc;
import java.util.ArrayList;
import java.util.List;

public class QuadrilateralTransformation
implements IProcessImage {
    private boolean automaticSizeCalculaton = true;
    private boolean useInterpolation = true;
    private int newWidth;
    private int newHeight;
    private List<IntPoint> sourceQuadrilateral;

    public boolean isAutomaticSizeCalculaton() {
        return this.automaticSizeCalculaton;
    }

    public void setAutomaticSizeCalculaton(boolean automaticSizeCalculaton) {
        this.automaticSizeCalculaton = automaticSizeCalculaton;
        if (automaticSizeCalculaton) {
            this.CalculateDestinationSize();
        }
    }

    public List<IntPoint> getSourceQuadrilateral() {
        return this.sourceQuadrilateral;
    }

    public void setSourceQuadrilateral(List<IntPoint> sourceQuadrilateral) {
        this.sourceQuadrilateral = sourceQuadrilateral;
        if (this.automaticSizeCalculaton) {
            this.CalculateDestinationSize();
        }
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
        if (!this.automaticSizeCalculaton) {
            this.newWidth = Math.max(1, newWidth);
        }
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
        if (!this.automaticSizeCalculaton) {
            this.newHeight = Math.max(1, newHeight);
        }
    }

    public boolean isUseInterpolation() {
        return this.useInterpolation;
    }

    public void setUseInterpolation(boolean useInterpolation) {
        this.useInterpolation = useInterpolation;
    }

    public QuadrilateralTransformation(List<IntPoint> sourceQuadrilateral) {
        this.automaticSizeCalculaton = true;
        this.sourceQuadrilateral = sourceQuadrilateral;
        this.CalculateDestinationSize();
    }

    public QuadrilateralTransformation(List<IntPoint> sourceQuadrilateral, int newWidth, int newHeight) {
        this.automaticSizeCalculaton = false;
        this.sourceQuadrilateral = sourceQuadrilateral;
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FastBitmap ProcessImage(FastBitmap fastBitmap) {
        FastBitmap dst;
        block16: {
            double dy2;
            double dy1;
            int sy2;
            int sy1;
            double dx2;
            double dx1;
            int sx2;
            int sx1;
            double[][] matrix;
            int dstHeight;
            int dstWidth;
            int srcHeight;
            int srcWidth;
            block15: {
                void var9_15;
                double srcY;
                double srcX;
                double factor;
                dst = new FastBitmap(this.newWidth, this.newHeight, fastBitmap.getColorSpace());
                srcWidth = fastBitmap.getWidth();
                srcHeight = fastBitmap.getHeight();
                dstWidth = this.newWidth;
                dstHeight = this.newHeight;
                ArrayList<IntPoint> dstRect = new ArrayList<IntPoint>();
                dstRect.add(new IntPoint(0, 0));
                dstRect.add(new IntPoint(dstWidth - 1, 0));
                dstRect.add(new IntPoint(dstWidth - 1, dstHeight - 1));
                dstRect.add(new IntPoint(0, dstHeight - 1));
                if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
                    for (IntPoint intPoint : this.sourceQuadrilateral) {
                        intPoint.Swap();
                    }
                }
                matrix = QuadrilateralTransformationCalc.MapQuadToQuad(dstRect, this.sourceQuadrilateral);
                if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
                    for (IntPoint p : this.sourceQuadrilateral) {
                        p.Swap();
                    }
                }
                if (this.useInterpolation) break block15;
                if (fastBitmap.isRGB()) {
                    void var9_13;
                    boolean bl = false;
                    while (var9_13 < dstHeight) {
                        for (int j = 0; j < dstWidth; ++j) {
                            factor = matrix[2][0] * (double)j + matrix[2][1] * (double)var9_13 + matrix[2][2];
                            srcX = (matrix[0][0] * (double)j + matrix[0][1] * (double)var9_13 + matrix[0][2]) / factor;
                            srcY = (matrix[1][0] * (double)j + matrix[1][1] * (double)var9_13 + matrix[1][2]) / factor;
                            if (!(srcX >= 0.0) || !(srcY >= 0.0) || !(srcX < (double)srcWidth) || !(srcY < (double)srcHeight)) continue;
                            int r = fastBitmap.getRed((int)srcY, (int)srcX);
                            int g = fastBitmap.getGreen((int)srcY, (int)srcX);
                            int b = fastBitmap.getBlue((int)srcY, (int)srcX);
                            dst.setRGB((int)var9_13, j, r, g, b);
                        }
                        ++var9_13;
                    }
                }
                if (!fastBitmap.isGrayscale()) break block16;
                boolean bl = false;
                while (var9_15 < dstHeight) {
                    for (int j = 0; j < dstWidth; ++j) {
                        factor = matrix[2][0] * (double)j + matrix[2][1] * (double)var9_15 + matrix[2][2];
                        srcX = (matrix[0][0] * (double)j + matrix[0][1] * (double)var9_15 + matrix[0][2]) / factor;
                        srcY = (matrix[1][0] * (double)j + matrix[1][1] * (double)var9_15 + matrix[1][2]) / factor;
                        if (!(srcX >= 0.0) || !(srcY >= 0.0) || !(srcX < (double)srcWidth) || !(srcY < (double)srcHeight)) continue;
                        int g = fastBitmap.getGray((int)srcY, (int)srcX);
                        dst.setGray((int)var9_15, j, g);
                    }
                    ++var9_15;
                }
                break block16;
            }
            if (fastBitmap.isRGB()) {
                int n = srcWidth - 1;
                int srcHeightM1 = srcHeight - 1;
                for (int i = 0; i < dstHeight; ++i) {
                    for (int j = 0; j < dstWidth; ++j) {
                        double factor = matrix[2][0] * (double)j + matrix[2][1] * (double)i + matrix[2][2];
                        double srcX = (matrix[0][0] * (double)j + matrix[0][1] * (double)i + matrix[0][2]) / factor;
                        double srcY = (matrix[1][0] * (double)j + matrix[1][1] * (double)i + matrix[1][2]) / factor;
                        if (!(srcX >= 0.0) || !(srcY >= 0.0) || !(srcX < (double)srcWidth) || !(srcY < (double)srcHeight)) continue;
                        sx1 = (int)srcX;
                        sx2 = sx1 == n ? sx1 : sx1 + 1;
                        dx1 = srcX - (double)sx1;
                        dx2 = 1.0 - dx1;
                        sy1 = (int)srcY;
                        sy2 = sy1 == srcHeightM1 ? sy1 : sy1 + 1;
                        dy1 = srcY - (double)sy1;
                        dy2 = 1.0 - dy1;
                        int p1r = fastBitmap.getRed(sy1, sx1);
                        int p2r = fastBitmap.getRed(sy1, sx2);
                        int p3r = fastBitmap.getRed(sy2, sx1);
                        int p4r = fastBitmap.getRed(sy2, sx2);
                        int p1g = fastBitmap.getGreen(sy1, sx1);
                        int p2g = fastBitmap.getGreen(sy1, sx2);
                        int p3g = fastBitmap.getGreen(sy2, sx1);
                        int p4g = fastBitmap.getGreen(sy2, sx2);
                        int p1b = fastBitmap.getBlue(sy1, sx1);
                        int p2b = fastBitmap.getBlue(sy1, sx2);
                        int p3b = fastBitmap.getBlue(sy2, sx1);
                        int p4b = fastBitmap.getBlue(sy2, sx2);
                        int r = (int)(dy2 * (dx2 * (double)p1r + dx1 * (double)p2r) + dy1 * (dx2 * (double)p3r + dx1 * (double)p4r));
                        int g = (int)(dy2 * (dx2 * (double)p1g + dx1 * (double)p2g) + dy1 * (dx2 * (double)p3g + dx1 * (double)p4g));
                        int b = (int)(dy2 * (dx2 * (double)p1b + dx1 * (double)p2b) + dy1 * (dx2 * (double)p3b + dx1 * (double)p4b));
                        dst.setRGB(i, j, r, g, b);
                    }
                }
            }
            if (fastBitmap.isGrayscale()) {
                int n = srcWidth - 1;
                int srcHeightM1 = srcHeight - 1;
                for (int i = 0; i < dstHeight; ++i) {
                    for (int j = 0; j < dstWidth; ++j) {
                        double factor = matrix[2][0] * (double)j + matrix[2][1] * (double)i + matrix[2][2];
                        double srcX = (matrix[0][0] * (double)j + matrix[0][1] * (double)i + matrix[0][2]) / factor;
                        double srcY = (matrix[1][0] * (double)j + matrix[1][1] * (double)i + matrix[1][2]) / factor;
                        if (!(srcX >= 0.0) || !(srcY >= 0.0) || !(srcX < (double)srcWidth) || !(srcY < (double)srcHeight)) continue;
                        sx1 = (int)srcX;
                        sx2 = sx1 == n ? sx1 : sx1 + 1;
                        dx1 = srcX - (double)sx1;
                        dx2 = 1.0 - dx1;
                        sy1 = (int)srcY;
                        sy2 = sy1 == srcHeightM1 ? sy1 : sy1 + 1;
                        dy1 = srcY - (double)sy1;
                        dy2 = 1.0 - dy1;
                        int p1 = fastBitmap.getGray(sy1, sx1);
                        int p2 = fastBitmap.getGray(sy1, sx2);
                        int p3 = fastBitmap.getGray(sy2, sx1);
                        int p4 = fastBitmap.getGray(sy2, sx2);
                        int g = (int)(dy2 * (dx2 * (double)p1 + dx1 * (double)p2) + dy1 * (dx2 * (double)p3 + dx1 * (double)p4));
                        dst.setGray(i, j, g);
                    }
                }
            }
        }
        return dst;
    }

    private void CalculateDestinationSize() {
        if (this.sourceQuadrilateral == null) {
            throw new IllegalArgumentException("Source quadrilateral was not set.");
        }
        this.newWidth = (int)Math.max(this.sourceQuadrilateral.get(0).DistanceTo(this.sourceQuadrilateral.get(1)), this.sourceQuadrilateral.get(2).DistanceTo(this.sourceQuadrilateral.get(3)));
        this.newHeight = (int)Math.max(this.sourceQuadrilateral.get(1).DistanceTo(this.sourceQuadrilateral.get(2)), this.sourceQuadrilateral.get(3).DistanceTo(this.sourceQuadrilateral.get(0)));
    }
}

