/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.DistanceTransform;
import Catalano.Math.Distances.Distance;
import java.util.ArrayList;

public class NearestNeighborMatrix {
    private Direction direction = Direction.Vertical;
    private int startIndex = 1;

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public NearestNeighborMatrix() {
    }

    public NearestNeighborMatrix(int startIndex) {
        this.startIndex = startIndex;
    }

    public NearestNeighborMatrix(Direction direction) {
        this.direction = direction;
    }

    public NearestNeighborMatrix(Direction direction, int startIndex) {
        this.direction = direction;
        this.startIndex = startIndex;
    }

    public int[][] ProcessImage(FastBitmap fastBitmap) {
        float[][] image = new DistanceTransform().Compute(fastBitmap);
        ArrayList<IntPoint> boundary = new ArrayList<IntPoint>();
        int height = image.length;
        int width = image[0].length;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                if (image[i][j] != 1.0f) continue;
                boundary.add(new IntPoint(i, j));
            }
        }
        return this.ProcessImage(fastBitmap, boundary);
    }

    public int[][] ProcessImage(FastBitmap fastBitmap, ArrayList<IntPoint> boundary) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int[][] matrix = new int[height][width];
        if (fastBitmap.isGrayscale()) {
            int j;
            int i;
            if (this.direction == Direction.Vertical) {
                int i2;
                int j2;
                int index = this.startIndex;
                for (j2 = 0; j2 < width; ++j2) {
                    for (i2 = 0; i2 < height; ++i2) {
                        if (fastBitmap.getGray(i2, j2) == 255) {
                            matrix[i2][j2] = index;
                        }
                        ++index;
                    }
                }
                for (j2 = 0; j2 < width; ++j2) {
                    for (i2 = 0; i2 < height; ++i2) {
                        if (fastBitmap.getGray(i2, j2) != 0) continue;
                        double minDistance = Double.MAX_VALUE;
                        IntPoint point = new IntPoint();
                        for (IntPoint p : boundary) {
                            double dist = Distance.SquaredEuclidean(i2, j2, p.x, p.y);
                            if (!(dist < minDistance)) continue;
                            minDistance = dist;
                            point = p;
                        }
                        matrix[i2][j2] = matrix[point.x][point.y];
                    }
                }
                return matrix;
            }
            int index = this.startIndex;
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (fastBitmap.getGray(i, j) == 255) {
                        matrix[i][j] = index;
                    }
                    ++index;
                }
            }
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (fastBitmap.getGray(i, j) != 0) continue;
                    double minDistance = Double.MAX_VALUE;
                    IntPoint point = new IntPoint();
                    for (IntPoint p : boundary) {
                        double dist = Distance.SquaredEuclidean(i, j, p.x, p.y);
                        if (!(dist < minDistance)) continue;
                        minDistance = dist;
                        point = p;
                    }
                    matrix[i][j] = matrix[point.x][point.y];
                }
            }
            return matrix;
        }
        return null;
    }

    public IntPoint getPoint(int nearestNeighborIndex, int width, int height) {
        int i = nearestNeighborIndex - 1;
        int x = (int)Math.floor(i / height);
        int y = i % width;
        return new IntPoint(x, y);
    }

    public static enum Direction {
        Horizontal,
        Vertical;

    }
}

