/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;

public class HoughLine
implements Comparable {
    private double theta;
    private double radius;
    private int intensity;
    private double relativeIntensity;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }

    public double getRelativeIntensity() {
        return this.relativeIntensity;
    }

    public void setRelativeIntensity(double relativeIntensity) {
        this.relativeIntensity = relativeIntensity;
    }

    public HoughLine() {
    }

    public HoughLine(double theta, double radius, int intensity, double relativeIntensity) {
        this.theta = theta;
        this.radius = radius;
        this.intensity = intensity;
        this.relativeIntensity = relativeIntensity;
    }

    public void DrawLine(FastBitmap fastBitmap, int gray) {
        if (fastBitmap.isGrayscale()) {
            int height = fastBitmap.getHeight();
            int width = fastBitmap.getWidth();
            int houghHeight = (int)(Math.sqrt(2.0) * (double)Math.max(height, width)) / 2;
            float centerX = width / 2;
            float centerY = height / 2;
            double tsin = Math.sin(this.theta);
            double tcos = Math.cos(this.theta);
            if (this.theta < 0.7853981633974483 || this.theta > 2.356194490192345) {
                for (int y = 0; y < width; ++y) {
                    int x = (int)((this.radius - (double)houghHeight - (double)((float)y - centerY) * tsin) / tcos + (double)centerX);
                    if (x >= height || x < 0) continue;
                    fastBitmap.setGray(x, y, gray);
                }
            } else {
                for (int x = 0; x < height; ++x) {
                    int y = (int)((this.radius - (double)houghHeight - (double)((float)x - centerX) * tcos) / tsin + (double)centerY);
                    if (y >= width || y < 0) continue;
                    fastBitmap.setGray(x, y, gray);
                }
            }
        } else {
            throw new IllegalArgumentException("DrawLine the image is RGB, should be Grayscale.");
        }
    }

    public void DrawLine(FastBitmap fastBitmap, int red, int green, int blue) {
        if (fastBitmap.isRGB()) {
            int height = fastBitmap.getHeight();
            int width = fastBitmap.getWidth();
            int houghHeight = (int)(Math.sqrt(2.0) * (double)Math.max(height, width)) / 2;
            float centerX = width / 2;
            float centerY = height / 2;
            double tsin = Math.sin(this.theta);
            double tcos = Math.cos(this.theta);
            if (this.theta < 0.7853981633974483 || this.theta > 2.356194490192345) {
                for (int y = 0; y < width; ++y) {
                    int x = (int)((this.radius - (double)houghHeight - (double)((float)y - centerY) * tsin) / tcos + (double)centerX);
                    if (x >= height || x < 0) continue;
                    fastBitmap.setRGB(x, y, red, green, blue);
                }
            } else {
                for (int x = 0; x < height; ++x) {
                    int y = (int)((this.radius - (double)houghHeight - (double)((float)x - centerX) * tcos) / tsin + (double)centerY);
                    if (y >= width || y < 0) continue;
                    fastBitmap.setRGB(x, y, red, green, blue);
                }
            }
        } else {
            throw new IllegalArgumentException("DrawLine the image is Grayscale, should be RGB.");
        }
    }

    public int compareTo(Object o) {
        HoughLine hl = (HoughLine)o;
        if (this.intensity > hl.intensity) {
            return -1;
        }
        if (this.intensity < hl.intensity) {
            return 1;
        }
        return 0;
    }
}

