/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Opening;

public class Granulometry {
    private int minRadius = 1;
    private int maxRadius = 10;
    private int steps = 1;

    public int getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(int minRadius) {
        this.minRadius = minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public Granulometry() {
    }

    public Granulometry(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    public Granulometry(int minRadius, int maxRadius) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public Granulometry(int minRadius, int maxRadius, int steps) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.steps = steps;
    }

    public float[] ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            long sumPixel;
            float[] density = new float[this.maxRadius - this.minRadius];
            long sumOriginal = sumPixel = this.getPixelSum(fastBitmap);
            int index = 0;
            for (int i = this.minRadius; i < this.maxRadius; i += this.steps) {
                FastBitmap copy = new FastBitmap(fastBitmap);
                Opening open = new Opening(i);
                open.applyInPlace(copy);
                long sumPixel2 = this.getPixelSum(copy);
                density[index] = -((float)(sumPixel2 - sumPixel)) / (float)sumOriginal;
                sumPixel2 = sumPixel;
                ++index;
            }
            return density;
        }
        throw new IllegalArgumentException("Granulometry only works in grayscale images.");
    }

    private long getPixelSum(FastBitmap fastBitmap) {
        long sum = 0L;
        for (int i = 0; i < fastBitmap.getHeight(); ++i) {
            for (int j = 0; j < fastBitmap.getWidth(); ++j) {
                sum += (long)fastBitmap.getGray(i, j);
            }
        }
        return sum;
    }
}

