/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.HoughLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentSkewChecker {
    private int stepsPerDegree = 10;
    private int houghHeight;
    private double thetaStep;
    private double maxSkewToDetect = 30.0;
    private double[] sinMap;
    private double[] cosMap;
    private boolean needToInitialize = true;
    private int[][] houghMap;
    private int maxMapIntensity = 0;
    private int localPeakRadius = 4;
    private List<HoughLine> lines = new ArrayList<HoughLine>();

    public int getStepsPerDegree() {
        return this.stepsPerDegree;
    }

    public void setStepsPerDegree(int stepsPerDegree) {
        this.stepsPerDegree = Math.max(1, Math.min(10, stepsPerDegree));
    }

    public double getMaxSkewToDetect() {
        return this.maxSkewToDetect;
    }

    public void setMaxSkewToDetect(double maxSkewToDetect) {
        this.maxSkewToDetect = Math.max(0.0, Math.min(45.0, maxSkewToDetect));
    }

    public int getLocalPeakRadius() {
        return this.localPeakRadius;
    }

    public void setLocalPeakRadius(int localPeakRadius) {
        this.localPeakRadius = Math.max(1, Math.min(10, localPeakRadius));
    }

    public double getSkewAngle(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.InitHoughMap();
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            int halfWidth = width / 2;
            int halfHeight = height / 2;
            int startX = -halfWidth;
            int startY = -halfHeight;
            int stopX = width - halfWidth;
            int stopY = height - halfHeight - 1;
            int halfHoughWidth = (int)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            int houghWidth = halfHoughWidth * 2;
            this.houghMap = new int[this.houghHeight][houghWidth];
            int indexG = 0;
            for (int y = startY; y < stopY; ++y) {
                int x = startX;
                while (x < stopX) {
                    if (fastBitmap.getGray(indexG) < 128 && fastBitmap.getGray(indexG + width) >= 128) {
                        for (int theta = 0; theta < this.houghHeight; ++theta) {
                            int radius = (int)(this.cosMap[theta] * (double)x - this.sinMap[theta] * (double)y) + halfHoughWidth;
                            if (radius < 0 || radius >= houghWidth) continue;
                            int[] nArray = this.houghMap[theta];
                            int n = radius;
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                    ++x;
                    ++indexG;
                }
            }
            this.maxMapIntensity = 0;
            for (int i = 0; i < this.houghHeight; ++i) {
                for (int j = 0; j < houghWidth; ++j) {
                    if (this.houghMap[i][j] <= this.maxMapIntensity) continue;
                    this.maxMapIntensity = this.houghMap[i][j];
                }
            }
            this.CollectLines(width / 10);
            HoughLine[] hls = this.GetMostIntensiveLines(5);
            double skewAngle = 0.0;
            double sumIntensity = 0.0;
            for (HoughLine hl : hls) {
                if (!(hl.getRelativeIntensity() > 0.5)) continue;
                skewAngle += hl.getTheta() * hl.getRelativeIntensity();
                sumIntensity += hl.getRelativeIntensity();
            }
            if (hls.length > 0) {
                skewAngle /= sumIntensity;
            }
            return skewAngle - 90.0;
        }
        throw new IllegalArgumentException("Document Skew Checker only works in grayscale images.");
    }

    private void CollectLines(int minLineIntensity) {
        int maxTheta = this.houghMap.length;
        int maxRadius = this.houghMap[0].length;
        int halfHoughWidth = maxRadius >> 1;
        this.lines.clear();
        for (int theta = 0; theta < maxTheta; ++theta) {
            for (int radius = 0; radius < maxRadius; ++radius) {
                int intensity = this.houghMap[theta][radius];
                if (intensity < minLineIntensity) continue;
                boolean foundGreater = false;
                int ttMax = theta + this.localPeakRadius;
                block2: for (int tt = theta - this.localPeakRadius; tt < ttMax; ++tt) {
                    if (tt < 0) continue;
                    if (tt >= maxTheta || foundGreater) break;
                    int trMax = radius + this.localPeakRadius;
                    for (int tr = radius - this.localPeakRadius; tr < trMax; ++tr) {
                        if (tr < 0) continue;
                        if (tr >= maxRadius) continue block2;
                        if (this.houghMap[tt][tr] <= intensity) continue;
                        foundGreater = true;
                        continue block2;
                    }
                }
                if (foundGreater) continue;
                this.lines.add(new HoughLine(90.0 - this.maxSkewToDetect + (double)theta / (double)this.stepsPerDegree, radius - halfHoughWidth, intensity, (double)intensity / (double)this.maxMapIntensity));
            }
        }
        Collections.sort(this.lines);
    }

    private HoughLine[] GetMostIntensiveLines(int count) {
        int n = Math.min(count, this.lines.size());
        HoughLine[] dst = new HoughLine[n];
        for (int i = 0; i < n; ++i) {
            dst[i] = this.lines.get(i);
        }
        return dst;
    }

    private void InitHoughMap() {
        if (this.needToInitialize) {
            this.needToInitialize = false;
            this.houghHeight = (int)(2.0 * this.maxSkewToDetect * (double)this.stepsPerDegree);
            this.thetaStep = 2.0 * this.maxSkewToDetect * Math.PI / 180.0 / (double)this.houghHeight;
            this.sinMap = new double[this.houghHeight];
            this.cosMap = new double[this.houghHeight];
            double minTheta = 90.0 - this.maxSkewToDetect;
            for (int i = 0; i < this.houghHeight; ++i) {
                this.sinMap[i] = Math.sin(minTheta * Math.PI / 180.0 + (double)i * this.thetaStep);
                this.cosMap[i] = Math.cos(minTheta * Math.PI / 180.0 + (double)i * this.thetaStep);
            }
        }
    }
}

