/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.ArraysUtil;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Crop;
import Catalano.Imaging.Tools.FiltersSequence;
import Catalano.Imaging.Tools.IAggregateVectors;
import java.util.ArrayList;

public class BlockProcessing {
    private int wBlock;
    private int hBlock;

    public BlockProcessing() {
        this(6, 6);
    }

    public BlockProcessing(int wBlock, int hBlock) {
        this.wBlock = wBlock;
        this.hBlock = hBlock;
    }

    public double[] Compute(FastBitmap fastBitmap, FiltersSequence filters, IAggregateVectors function) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int wDiv = (int)Math.round((double)width / (double)this.wBlock) - 1;
        int hDiv = (int)Math.round((double)height / (double)this.hBlock) - 1;
        ArrayList<double[]> vectors = new ArrayList<double[]>();
        for (int i = 0; i < this.hBlock; ++i) {
            for (int j = 0; j < this.wBlock; ++j) {
                FastBitmap copy = this.getSubimage(fastBitmap, i * hDiv, j * wDiv, wDiv, hDiv);
                filters.applyInPlace(copy);
                vectors.add(function.Compute(copy));
            }
        }
        return ArraysUtil.ConcatenateDouble(vectors);
    }

    public double[] Compute(FastBitmap fastBitmap, IAggregateVectors function) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int wDiv = (int)Math.round((double)width / (double)this.wBlock) - 1;
        int hDiv = (int)Math.round((double)height / (double)this.hBlock) - 1;
        ArrayList<double[]> vectors = new ArrayList<double[]>();
        for (int i = 0; i < this.hBlock; ++i) {
            for (int j = 0; j < this.wBlock; ++j) {
                FastBitmap copy = this.getSubimage(fastBitmap, i * hDiv, j * wDiv, wDiv, hDiv);
                vectors.add(function.Compute(copy));
            }
        }
        return ArraysUtil.ConcatenateDouble(vectors);
    }

    private FastBitmap getSubimage(FastBitmap fastBitmap, int x, int y, int width, int height) {
        FastBitmap copy = new FastBitmap(fastBitmap);
        Crop crop = new Crop(x, y, width, height);
        crop.applyInPlace(copy);
        return copy;
    }
}

