/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

import Catalano.Imaging.FastBitmap;

public class GrayLevelCooccurrenceMatrix {
    private Degree degree;
    private int levels = 8;
    private boolean normalize = true;
    private int numPairs = 0;
    private int distance = 1;

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getNumPairs() {
        return this.numPairs;
    }

    public GrayLevelCooccurrenceMatrix() {
        this(1, Degree.Degree_0, 256, false);
    }

    public GrayLevelCooccurrenceMatrix(int distance) {
        this.distance = distance;
    }

    public GrayLevelCooccurrenceMatrix(int distance, Degree degree) {
        this.distance = distance;
        this.degree = degree;
    }

    public GrayLevelCooccurrenceMatrix(int distance, Degree degree, boolean normalize) {
        this.distance = distance;
        this.degree = degree;
        this.normalize = normalize;
    }

    public GrayLevelCooccurrenceMatrix(int distance, Degree degree, int levels, boolean normalize) {
        this.distance = distance;
        this.degree = degree;
        this.levels = levels;
        this.normalize = normalize;
    }

    public double[][] Compute(FastBitmap fastBitmap) {
        int maxGray = this.getMax(fastBitmap);
        if (maxGray < this.levels) {
            maxGray = this.levels;
        }
        int div = maxGray / (this.levels - 1);
        this.numPairs = 0;
        double[][] coocurrence = new double[this.levels][this.levels];
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        switch (this.degree) {
            case Degree_0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = this.distance; j < width; ++j) {
                        int g1 = fastBitmap.getGray(i, j - this.distance) / div;
                        int g2 = fastBitmap.getGray(i, j) / div;
                        if (g1 >= this.levels) {
                            g1 = this.levels - 1;
                        }
                        if (g2 >= this.levels) {
                            g2 = this.levels - 1;
                        }
                        double[] dArray = coocurrence[g1];
                        int n = g2;
                        dArray[n] = dArray[n] + 1.0;
                        ++this.numPairs;
                    }
                }
                break;
            }
            case Degree_45: {
                for (int x = this.distance; x < height; ++x) {
                    for (int y = 0; y < width - this.distance; ++y) {
                        int g1 = fastBitmap.getGray(x, y) / div;
                        int g2 = fastBitmap.getGray(x - this.distance, y + this.distance) / div;
                        if (g1 >= this.levels) {
                            g1 = this.levels - 1;
                        }
                        if (g2 >= this.levels) {
                            g2 = this.levels - 1;
                        }
                        double[] dArray = coocurrence[g1];
                        int n = g2;
                        dArray[n] = dArray[n] + 1.0;
                        ++this.numPairs;
                    }
                }
                break;
            }
            case Degree_90: {
                for (int i = this.distance; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int g1 = fastBitmap.getGray(i - this.distance, j) / div;
                        int g2 = fastBitmap.getGray(i, j) / div;
                        if (g1 >= this.levels) {
                            g1 = this.levels - 1;
                        }
                        if (g2 >= this.levels) {
                            g2 = this.levels - 1;
                        }
                        double[] dArray = coocurrence[g1];
                        int n = g2;
                        dArray[n] = dArray[n] + 1.0;
                        ++this.numPairs;
                    }
                }
                break;
            }
            case Degree_135: {
                for (int x = this.distance; x < height; ++x) {
                    int steps = width - 1;
                    for (int y = 0; y < width - this.distance; ++y) {
                        int g1 = fastBitmap.getGray(x, steps - y) / div;
                        int g2 = fastBitmap.getGray(x - this.distance, steps - this.distance - y) / div;
                        if (g1 >= this.levels) {
                            g1 = this.levels - 1;
                        }
                        if (g2 >= this.levels) {
                            g2 = this.levels - 1;
                        }
                        double[] dArray = coocurrence[g1];
                        int n = g2;
                        dArray[n] = dArray[n] + 1.0;
                        ++this.numPairs;
                    }
                }
                break;
            }
        }
        if (this.normalize) {
            this.Normalize(coocurrence, this.numPairs == 0 ? 1 : this.numPairs);
        }
        return coocurrence;
    }

    private void Normalize(double[][] coocurrenceMatrix, int numPairs) {
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            int j = 0;
            while (j < coocurrenceMatrix[0].length) {
                double[] dArray = coocurrenceMatrix[i];
                int n = j++;
                dArray[n] = dArray[n] / (double)numPairs;
            }
        }
    }

    private int getMax(FastBitmap fastBitmap) {
        int max = 0;
        for (int i = 0; i < fastBitmap.getHeight(); ++i) {
            for (int j = 0; j < fastBitmap.getWidth(); ++j) {
                int gray = fastBitmap.getGray(i, j);
                if (gray <= max) continue;
                max = gray;
            }
        }
        return max;
    }

    public static enum Degree {
        Degree_0,
        Degree_45,
        Degree_90,
        Degree_135;

    }
}

