/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;

public class WeberBinaryPattern
implements IBinaryPattern {
    private double threshold;

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public WeberBinaryPattern() {
        this(-0.2);
    }

    public WeberBinaryPattern(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("WBP works only with grayscale images.");
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[256];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                double cp = fastBitmap.getGray(x, y);
                int sum = 0;
                if (((double)fastBitmap.getGray(x - 1, y - 1) - cp) / cp > this.threshold) {
                    sum += 128;
                }
                if (((double)fastBitmap.getGray(x - 1, y) - cp) / cp > this.threshold) {
                    sum += 64;
                }
                if (((double)fastBitmap.getGray(x - 1, y + 1) - cp) / cp > this.threshold) {
                    sum += 32;
                }
                if (((double)fastBitmap.getGray(x, y + 1) - cp) / cp > this.threshold) {
                    sum += 16;
                }
                if (((double)fastBitmap.getGray(x + 1, y + 1) - cp) / cp > this.threshold) {
                    sum += 8;
                }
                if (((double)fastBitmap.getGray(x + 1, y) - cp) / cp > this.threshold) {
                    sum += 4;
                }
                if (((double)fastBitmap.getGray(x + 1, y - 1) - cp) / cp > this.threshold) {
                    sum += 2;
                }
                if (((double)fastBitmap.getGray(x, y - 1) - cp) / cp > this.threshold) {
                    // empty if block
                }
                int n = ++sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

