/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Imaging.Tools.IntegralImage;

public class MultiblockLocalBinaryPattern
implements IBinaryPattern {
    private int recWidth;
    private int recHeight;

    public MultiblockLocalBinaryPattern() {
        this(3, 2);
    }

    public MultiblockLocalBinaryPattern(int width, int height) {
        this.recWidth = width;
        this.recHeight = height;
    }

    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            try {
                throw new Exception("Multiblock LBP works only with grayscale images.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IntegralImage ii = new IntegralImage(fastBitmap);
        int[] hist = new int[256];
        int width = fastBitmap.getWidth() - 3 * this.recWidth;
        int height = fastBitmap.getHeight() - 3 * this.recHeight;
        int[] mask = new int[9];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                mask[0] = (int)ii.getRectangleMean(i, j, i + this.recHeight - 1, j + this.recWidth - 1);
                mask[1] = (int)ii.getRectangleMean(i, j + this.recWidth - 1, i + this.recHeight - 1, j + 2 * this.recWidth - 1);
                mask[2] = (int)ii.getRectangleMean(i, j + 2 * this.recWidth, i + this.recHeight - 1, j + 3 * this.recWidth - 1);
                mask[3] = (int)ii.getRectangleMean(i + this.recHeight, j, i + 2 * this.recHeight - 1, j + this.recWidth - 1);
                mask[4] = (int)ii.getRectangleMean(i + this.recHeight, j + this.recWidth - 1, i + 2 * this.recHeight - 1, j + 2 * this.recWidth - 1);
                mask[5] = (int)ii.getRectangleMean(i + this.recHeight, j + 2 * this.recWidth, i + 2 * this.recHeight - 1, j + 3 * this.recWidth - 1);
                mask[6] = (int)ii.getRectangleMean(i + 2 * this.recHeight, j, i + 3 * this.recHeight - 1, j + this.recWidth - 1);
                mask[7] = (int)ii.getRectangleMean(i + 2 * this.recHeight, j + this.recWidth - 1, i + 3 * this.recHeight - 1, j + 2 * this.recWidth - 1);
                mask[8] = (int)ii.getRectangleMean(i + 2 * this.recHeight, j + 2 * this.recWidth, i + 3 * this.recHeight - 1, j + 3 * this.recWidth - 1);
                int sum = 0;
                if (mask[0] - mask[4] >= 0) {
                    sum += 128;
                }
                if (mask[1] - mask[4] >= 0) {
                    sum += 64;
                }
                if (mask[2] - mask[4] >= 0) {
                    sum += 32;
                }
                if (mask[5] - mask[4] >= 0) {
                    sum += 16;
                }
                if (mask[8] - mask[4] >= 0) {
                    sum += 8;
                }
                if (mask[7] - mask[4] >= 0) {
                    sum += 4;
                }
                if (mask[6] - mask[4] >= 0) {
                    sum += 2;
                }
                if (mask[3] - mask[4] >= 0) {
                    // empty if block
                }
                int n = ++sum;
                hist[n] = hist[n] + 1;
            }
        }
        return new ImageHistogram(hist);
    }
}

