/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;
import java.util.Arrays;

public class MedianBinaryPattern
implements IBinaryPattern {
    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("MBP only works in grayscale images.");
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[511];
        int[] values = new int[9];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                values[0] = fastBitmap.getGray(x - 1, y - 1);
                values[1] = fastBitmap.getGray(x - 1, y);
                values[2] = fastBitmap.getGray(x - 1, y + 1);
                values[3] = fastBitmap.getGray(x, y - 1);
                values[4] = fastBitmap.getGray(x, y);
                values[5] = fastBitmap.getGray(x, y + 1);
                values[6] = fastBitmap.getGray(x + 1, y - 1);
                values[7] = fastBitmap.getGray(x + 1, y);
                values[8] = fastBitmap.getGray(x + 1, y + 1);
                Arrays.sort(values);
                int median = values[4];
                int sum = 0;
                if (fastBitmap.getGray(x - 1, y - 1) - median >= 0) {
                    sum += 128;
                }
                if (fastBitmap.getGray(x - 1, y) - median >= 0) {
                    sum += 64;
                }
                if (fastBitmap.getGray(x - 1, y + 1) - median >= 0) {
                    sum += 32;
                }
                if (fastBitmap.getGray(x, y + 1) - median >= 0) {
                    sum += 16;
                }
                if (fastBitmap.getGray(x + 1, y + 1) - median >= 0) {
                    sum += 8;
                }
                if (fastBitmap.getGray(x + 1, y) - median >= 0) {
                    sum += 4;
                }
                if (fastBitmap.getGray(x + 1, y - 1) - median >= 0) {
                    sum += 2;
                }
                if (fastBitmap.getGray(x, y - 1) - median >= 0) {
                    ++sum;
                }
                if (fastBitmap.getGray(x, y) - median >= 0) {
                    sum += 256;
                }
                if (sum == 511) {
                    sum = 0;
                }
                int n = sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

