/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;

public class ImprovedLocalBinaryPattern
implements IBinaryPattern {
    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("ILBP works only with grayscale images.");
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[511];
        for (int x = 1; x < height; ++x) {
            int mean = 0;
            for (int y = 1; y < width; ++y) {
                mean += fastBitmap.getGray(x - 1, y - 1);
                mean += fastBitmap.getGray(x - 1, y);
                mean += fastBitmap.getGray(x - 1, y + 1);
                mean += fastBitmap.getGray(x, y - 1);
                mean += fastBitmap.getGray(x, y);
                mean += fastBitmap.getGray(x, y + 1);
                mean += fastBitmap.getGray(x + 1, y - 1);
                mean += fastBitmap.getGray(x + 1, y);
                mean += fastBitmap.getGray(x + 1, y + 1);
                int sum = 0;
                if (fastBitmap.getGray(x - 1, y - 1) - (mean /= 9) >= 0) {
                    sum += 128;
                }
                if (fastBitmap.getGray(x - 1, y) - mean >= 0) {
                    sum += 64;
                }
                if (fastBitmap.getGray(x - 1, y + 1) - mean >= 0) {
                    sum += 32;
                }
                if (fastBitmap.getGray(x, y + 1) - mean >= 0) {
                    sum += 16;
                }
                if (fastBitmap.getGray(x + 1, y + 1) - mean >= 0) {
                    sum += 8;
                }
                if (fastBitmap.getGray(x + 1, y) - mean >= 0) {
                    sum += 4;
                }
                if (fastBitmap.getGray(x + 1, y - 1) - mean >= 0) {
                    sum += 2;
                }
                if (fastBitmap.getGray(x, y - 1) - mean >= 0) {
                    ++sum;
                }
                if (fastBitmap.getGray(x, y) - mean >= 0) {
                    sum += 256;
                }
                if (sum == 511) {
                    sum = 0;
                }
                int n = sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

