/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;

public class CenterSymmetricLocalBinaryPattern
implements IBinaryPattern {
    private double threshold;

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public CenterSymmetricLocalBinaryPattern() {
        this(0.1);
    }

    public CenterSymmetricLocalBinaryPattern(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("CS-LBP only works in grayscale images.");
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[16];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                int sum = 0;
                this.threshold = fastBitmap.getGray(x, y);
                if ((double)Math.abs(fastBitmap.getGray(x - 1, y - 1) - fastBitmap.getGray(x + 1, y + 1)) >= this.threshold) {
                    sum += 8;
                }
                if ((double)Math.abs(fastBitmap.getGray(x - 1, y) - fastBitmap.getGray(x + 1, y)) >= this.threshold) {
                    sum += 4;
                }
                if ((double)Math.abs(fastBitmap.getGray(x - 1, y + 1) - fastBitmap.getGray(x + 1, y - 1)) >= this.threshold) {
                    sum += 2;
                }
                if ((double)Math.abs(fastBitmap.getGray(x, y + 1) - fastBitmap.getGray(x, y - 1)) >= this.threshold) {
                    // empty if block
                }
                int n = ++sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

