/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class WhitePatch
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int i;
            int size = fastBitmap.getSize();
            double maxR = 1.0;
            double maxG = 1.0;
            double maxB = 1.0;
            for (i = 0; i < size; ++i) {
                if ((double)fastBitmap.getRed(i) > maxR) {
                    maxR = fastBitmap.getRed(i);
                }
                if ((double)fastBitmap.getGreen(i) > maxG) {
                    maxG = fastBitmap.getGreen(i);
                }
                if (!((double)fastBitmap.getBlue(i) > maxB)) continue;
                maxB = fastBitmap.getBlue(i);
            }
            maxR = 255.0 / maxR;
            maxG = 255.0 / maxG;
            maxB = 255.0 / maxB;
            for (i = 0; i < size; ++i) {
                double r = maxR * (double)fastBitmap.getRed(i);
                double g = maxG * (double)fastBitmap.getGreen(i);
                double b = maxB * (double)fastBitmap.getBlue(i);
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                fastBitmap.setRGB(i, (int)r, (int)g, (int)b);
            }
        } else {
            throw new IllegalArgumentException("White Patch only works in RGB space.");
        }
    }
}

