/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class WeightedMedian
implements IApplyInPlace {
    private int[][] weight = new int[][]{{1, 2, 1}, {2, 3, 2}, {1, 2, 1}};

    public int[][] getWeight() {
        return this.weight;
    }

    public void setWeight(int[][] weight) {
        this.weight = weight;
    }

    public WeightedMedian() {
    }

    public WeightedMedian(int[][] weight) {
        this.setWeight(weight);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block11: {
            FastBitmap copy;
            int maxArray;
            int radiusJ;
            int radiusI;
            int height;
            int width;
            block10: {
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                radiusI = (this.weight.length - 1) / 2;
                radiusJ = (this.weight[0].length - 1) / 2;
                maxArray = this.calcMax(this.weight);
                copy = new FastBitmap(fastBitmap);
                if (!fastBitmap.isGrayscale()) break block10;
                int[] avgL = new int[maxArray];
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int c = 0;
                        for (int i = 0; i < this.weight.length; ++i) {
                            int Xline = x + (i - radiusI);
                            for (int j = 0; j < this.weight[0].length; ++j) {
                                int Yline = y + (j - radiusJ);
                                if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width || this.weight[i][j] <= 0) continue;
                                for (int k = 0; k < this.weight[i][j]; ++k) {
                                    avgL[c] = copy.getGray(Xline, Yline);
                                    ++c;
                                }
                            }
                        }
                        Arrays.sort(avgL, 0, c);
                        int median = c / 2;
                        fastBitmap.setGray(x, y, avgL[median]);
                    }
                }
                break block11;
            }
            if (!fastBitmap.isRGB()) break block11;
            int[] avgR = new int[maxArray];
            int[] avgG = new int[maxArray];
            int[] avgB = new int[maxArray];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int c = 0;
                    for (int i = 0; i < this.weight.length; ++i) {
                        int Xline = x + (i - radiusI);
                        for (int j = 0; j < this.weight[0].length; ++j) {
                            int Yline = y + (j - radiusJ);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width || this.weight[i][j] <= 0) continue;
                            for (int k = 0; k < this.weight[i][j]; ++k) {
                                avgR[c] = copy.getRed(Xline, Yline);
                                avgG[c] = copy.getGreen(Xline, Yline);
                                avgB[c] = copy.getBlue(Xline, Yline);
                                ++c;
                            }
                        }
                    }
                    Arrays.sort(avgR, 0, c);
                    Arrays.sort(avgG, 0, c);
                    Arrays.sort(avgB, 0, c);
                    int median = c / 2;
                    fastBitmap.setRGB(x, y, avgR[median], avgG[median], avgB[median]);
                }
            }
        }
    }

    private int calcMax(int[][] weight) {
        int s = 0;
        for (int i = 0; i < weight.length; ++i) {
            for (int j = 0; j < weight[0].length; ++j) {
                if (weight[i][j] <= 0) continue;
                s += weight[i][j];
            }
        }
        return s;
    }
}

