/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.GaussianBoxBlur;
import Catalano.Imaging.IApplyInPlace;

public class UnsharpMasking
implements IApplyInPlace {
    private int radius = 1;
    private float weight = 0.6f;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(radius, 1);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = Math.max(0.0f, Math.min(weight, 1.0f));
    }

    public UnsharpMasking() {
    }

    public UnsharpMasking(int radius, float weight) {
        this.setRadius(radius);
        this.setWeight(weight);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap blur = new FastBitmap(fastBitmap);
        GaussianBoxBlur gb = new GaussianBoxBlur(this.radius);
        gb.applyInPlace(blur);
        int size = fastBitmap.getSize();
        if (fastBitmap.isGrayscale()) {
            for (int i = 0; i < size; ++i) {
                int g = (int)(((float)fastBitmap.getGray(i) - this.weight * (float)blur.getGray(i)) / (1.0f - this.weight));
                fastBitmap.setGray(i, fastBitmap.clampValues(g, 0, 255));
            }
        } else if (fastBitmap.isRGB()) {
            for (int i = 0; i < size; ++i) {
                int r = (int)(((float)fastBitmap.getRed(i) - this.weight * (float)blur.getRed(i)) / (1.0f - this.weight));
                int g = (int)(((float)fastBitmap.getGreen(i) - this.weight * (float)blur.getGreen(i)) / (1.0f - this.weight));
                int b = (int)(((float)fastBitmap.getBlue(i) - this.weight * (float)blur.getBlue(i)) / (1.0f - this.weight));
                r = fastBitmap.clampValues(r, 0, 255);
                g = fastBitmap.clampValues(g, 0, 255);
                b = fastBitmap.clampValues(b, 0, 255);
                fastBitmap.setRGB(i, r, g, b);
            }
        } else {
            throw new IllegalArgumentException("Unsharp mask only works in grayscale or rgb images.");
        }
    }
}

