/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Subtract
implements IApplyInPlace {
    private FastBitmap overlayImage;
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private int gray = 0;
    private boolean isOverlay = false;

    public Subtract() {
    }

    public Subtract(int gray) {
        this.gray = Math.abs(gray);
    }

    public Subtract(int r, int g, int b) {
        this.red = Math.abs(r);
        this.green = Math.abs(g);
        this.blue = Math.abs(b);
    }

    public Subtract(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
        this.isOverlay = true;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
        this.isOverlay = true;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        if (this.isOverlay) {
            this.ApplyInPlaceImage(sourceImage);
        } else {
            this.ApplyInPlaceValues(sourceImage);
        }
    }

    private void ApplyInPlaceValues(FastBitmap sourceImage) {
        block3: {
            int size;
            block2: {
                size = sourceImage.getSize();
                if (!sourceImage.isGrayscale()) break block2;
                for (int i = 0; i < size; ++i) {
                    int l = sourceImage.getGray(i) - this.gray;
                    l = l < 0 ? 0 : l;
                    sourceImage.setGray(i, l);
                }
                break block3;
            }
            if (!sourceImage.isRGB()) break block3;
            for (int i = 0; i < size; ++i) {
                int r = sourceImage.getRed(i) - this.red;
                int g = sourceImage.getGreen(i) - this.green;
                int b = sourceImage.getBlue(i) - this.blue;
                r = r < 0 ? 0 : r;
                g = g < 0 ? 0 : g;
                b = b < 0 ? 0 : b;
                sourceImage.setRGB(i, r, g, b);
            }
        }
    }

    private void ApplyInPlaceImage(FastBitmap sourceImage) {
        block4: {
            int sizeDestination;
            int size;
            block3: {
                size = sourceImage.getSize();
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block3;
                if (size != sizeDestination) break block4;
                for (int i = 0; i < size; ++i) {
                    int l = sourceImage.getGray(i) - this.overlayImage.getGray(i);
                    l = l < 0 ? 0 : l;
                    sourceImage.setGray(i, l);
                }
                break block4;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && size == sizeDestination) {
                for (int i = 0; i < size; ++i) {
                    int r = sourceImage.getRed(i) - this.overlayImage.getRed(i);
                    int g = sourceImage.getGreen(i) - this.overlayImage.getGreen(i);
                    int b = sourceImage.getBlue(i) - this.overlayImage.getBlue(i);
                    r = r < 0 ? 0 : r;
                    g = g < 0 ? 0 : g;
                    b = b < 0 ? 0 : b;
                    sourceImage.setRGB(i, r, g, b);
                }
            }
        }
    }
}

