/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Random;

public class SaltAndPepperNoise
implements IApplyInPlace {
    private int noiseAmount = 10;
    private Random random = new Random();

    public SaltAndPepperNoise() {
    }

    public SaltAndPepperNoise(int noiseAmount) {
        this.noiseAmount = Math.max(0, Math.min(100, noiseAmount));
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block5: {
            int noise;
            int height;
            int width;
            block4: {
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                noise = width * height * this.noiseAmount / 200;
                if (!fastBitmap.isGrayscale()) break block4;
                for (int i = 0; i < noise; ++i) {
                    int x = this.random.nextInt(height);
                    int y = this.random.nextInt(width);
                    int[] c = new int[]{0, 255};
                    int color = this.random.nextInt(2);
                    fastBitmap.setGray(x, y, c[color]);
                }
                break block5;
            }
            if (!fastBitmap.isRGB()) break block5;
            for (int i = 0; i < noise; ++i) {
                int x = this.random.nextInt(height);
                int y = this.random.nextInt(width);
                int[] c = new int[]{0, 255};
                int band = this.random.nextInt(2);
                int color = this.random.nextInt(2);
                if (band == 0) {
                    fastBitmap.setRed(x, y, c[color]);
                    continue;
                }
                if (band == 1) {
                    fastBitmap.setGreen(x, y, c[color]);
                    continue;
                }
                if (band != 2) continue;
                fastBitmap.setBlue(x, y, c[color]);
            }
        }
    }
}

