/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class RotateNearestNeighbor
implements IApply,
IApplyInPlace {
    private double angle;
    private boolean keepSize;
    private int newWidth;
    private int newHeight;
    private int fillRed = 0;
    private int fillGreen = 0;
    private int fillBlue = 0;
    private int fillGray = 0;

    public double getAngle() {
        return -this.angle;
    }

    public void setAngle(double angle) {
        this.angle = -angle;
    }

    public boolean isKeepSize() {
        return this.keepSize;
    }

    public void setKeepSize(boolean keepSize) {
        this.keepSize = keepSize;
    }

    public void setFillColor(int red, int green, int blue) {
        this.fillRed = red;
        this.fillGreen = green;
        this.fillBlue = blue;
    }

    public void setFillColor(int gray) {
        this.fillGray = gray;
    }

    public RotateNearestNeighbor(double angle) {
        this.angle = -angle;
        this.keepSize = false;
    }

    public RotateNearestNeighbor(double angle, boolean keepSize) {
        this.angle = -angle;
        this.keepSize = keepSize;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double oldIradius = (double)(height - 1) / 2.0;
            double oldJradius = (double)(width - 1) / 2.0;
            this.CalculateNewSize(fastBitmap);
            FastBitmap destinationData = new FastBitmap(this.newWidth, this.newHeight, FastBitmap.ColorSpace.Grayscale);
            double newIradius = (double)(this.newHeight - 1) / 2.0;
            double newJradius = (double)(this.newWidth - 1) / 2.0;
            double angleRad = -this.angle * Math.PI / 180.0;
            double angleCos = Math.cos(angleRad);
            double angleSin = Math.sin(angleRad);
            double ci = -newIradius;
            for (int i = 0; i < this.newHeight; ++i) {
                double cj = -newJradius;
                for (int j = 0; j < this.newWidth; ++j) {
                    int oi = (int)(angleCos * ci + angleSin * cj + oldIradius);
                    int oj = (int)(-angleSin * ci + angleCos * cj + oldJradius);
                    if (oi < 0 || oj < 0 || oi >= height || oj >= width) {
                        destinationData.setGray(i, j, this.fillGray);
                    } else {
                        destinationData.setGray(i, j, fastBitmap.getGray(oi, oj));
                    }
                    cj += 1.0;
                }
                ci += 1.0;
            }
            return destinationData;
        }
        if (fastBitmap.isRGB()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double oldIradius = (double)(height - 1) / 2.0;
            double oldJradius = (double)(width - 1) / 2.0;
            this.CalculateNewSize(fastBitmap);
            FastBitmap destinationData = new FastBitmap(this.newWidth, this.newHeight, FastBitmap.ColorSpace.RGB);
            double newIradius = (double)(this.newHeight - 1) / 2.0;
            double newJradius = (double)(this.newWidth - 1) / 2.0;
            double angleRad = -this.angle * Math.PI / 180.0;
            double angleCos = Math.cos(angleRad);
            double angleSin = Math.sin(angleRad);
            double ci = -newIradius;
            for (int i = 0; i < this.newHeight; ++i) {
                double cj = -newJradius;
                for (int j = 0; j < this.newWidth; ++j) {
                    int oi = (int)(angleCos * ci + angleSin * cj + oldIradius);
                    int oj = (int)(-angleSin * ci + angleCos * cj + oldJradius);
                    if (oi < 0 || oj < 0 || oi >= height || oj >= width) {
                        destinationData.setRGB(i, j, this.fillRed, this.fillGreen, this.fillBlue);
                    } else {
                        int r = fastBitmap.getRed(oi, oj);
                        int g = fastBitmap.getGreen(oi, oj);
                        int b = fastBitmap.getBlue(oi, oj);
                        destinationData.setRGB(i, j, r, g, b);
                    }
                    cj += 1.0;
                }
                ci += 1.0;
            }
            return destinationData;
        }
        return null;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }

    private void CalculateNewSize(FastBitmap fastBitmap) {
        if (this.keepSize) {
            this.newWidth = fastBitmap.getWidth();
            this.newHeight = fastBitmap.getHeight();
            return;
        }
        double angleRad = -this.angle * Math.PI / 180.0;
        double angleCos = Math.cos(angleRad);
        double angleSin = Math.sin(angleRad);
        double halfWidth = (double)fastBitmap.getWidth() / 2.0;
        double halfHeight = (double)fastBitmap.getHeight() / 2.0;
        double cx1 = halfWidth * angleCos;
        double cy1 = halfWidth * angleSin;
        double cx2 = halfWidth * angleCos - halfHeight * angleSin;
        double cy2 = halfWidth * angleSin + halfHeight * angleCos;
        double cx3 = -halfHeight * angleSin;
        double cy3 = halfHeight * angleCos;
        double cx4 = 0.0;
        double cy4 = 0.0;
        halfWidth = Math.max(Math.max(cx1, cx2), Math.max(cx3, cx4)) - Math.min(Math.min(cx1, cx2), Math.min(cx3, cx4));
        halfHeight = Math.max(Math.max(cy1, cy2), Math.max(cy3, cy4)) - Math.min(Math.min(cy1, cy2), Math.min(cy3, cy4));
        this.newWidth = (int)(halfWidth * 2.0 + 0.5);
        this.newHeight = (int)(halfHeight * 2.0 + 0.5);
    }
}

