/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.Interpolation;

public class ResizeBicubic
implements IApply,
IApplyInPlace {
    private int newWidth;
    private int newHeight;

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    public void setNewSize(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public ResizeBicubic(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        FastBitmap dest = new FastBitmap(this.newWidth, this.newHeight, fastBitmap.getColorSpace());
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double jFactor = (double)width / (double)this.newWidth;
            double iFactor = (double)height / (double)this.newHeight;
            int imax = height - 1;
            int jmax = width - 1;
            for (int i = 0; i < this.newHeight; ++i) {
                double oy = (double)i * iFactor - 0.5;
                int oy1 = (int)oy;
                double dy = oy - (double)oy1;
                for (int j = 0; j < this.newWidth; ++j) {
                    double ox = (double)j * jFactor - 0.5;
                    int ox1 = (int)ox;
                    double dx = ox - (double)ox1;
                    int g = 0;
                    for (int n = -1; n < 3; ++n) {
                        double k1 = Interpolation.BiCubicKernel(dy - (double)n);
                        int oy2 = oy1 + n;
                        if (oy2 < 0) {
                            oy2 = 0;
                        }
                        if (oy2 > imax) {
                            oy2 = imax;
                        }
                        for (int m = -1; m < 3; ++m) {
                            double k2 = k1 * Interpolation.BiCubicKernel((double)m - dx);
                            int ox2 = ox1 + m;
                            if (ox2 < 0) {
                                ox2 = 0;
                            }
                            if (ox2 > jmax) {
                                ox2 = jmax;
                            }
                            g = (int)((double)g + k2 * (double)fastBitmap.getGray(oy2, ox2));
                        }
                    }
                    g = Math.max(0, Math.min(255, g));
                    dest.setGray(i, j, g);
                }
            }
            return dest;
        }
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double jFactor = (double)width / (double)this.newWidth;
        double iFactor = (double)height / (double)this.newHeight;
        int imax = height - 1;
        int jmax = width - 1;
        for (int i = 0; i < this.newHeight; ++i) {
            double oy = (double)i * iFactor - 0.5;
            int oy1 = (int)oy;
            double dy = oy - (double)oy1;
            for (int j = 0; j < this.newWidth; ++j) {
                double ox = (double)j * jFactor - 0.5;
                int ox1 = (int)ox;
                double dx = ox - (double)ox1;
                int b = 0;
                int g = 0;
                int r = 0;
                for (int n = -1; n < 3; ++n) {
                    double k1 = Interpolation.BiCubicKernel(dy - (double)n);
                    int oy2 = oy1 + n;
                    if (oy2 < 0) {
                        oy2 = 0;
                    }
                    if (oy2 > imax) {
                        oy2 = imax;
                    }
                    for (int m = -1; m < 3; ++m) {
                        double k2 = k1 * Interpolation.BiCubicKernel((double)m - dx);
                        int ox2 = ox1 + m;
                        if (ox2 < 0) {
                            ox2 = 0;
                        }
                        if (ox2 > jmax) {
                            ox2 = jmax;
                        }
                        r = (int)((double)r + k2 * (double)fastBitmap.getRed(oy2, ox2));
                        g = (int)((double)g + k2 * (double)fastBitmap.getGreen(oy2, ox2));
                        b = (int)((double)b + k2 * (double)fastBitmap.getBlue(oy2, ox2));
                    }
                }
                r = Math.max(0, Math.min(255, r));
                g = Math.max(0, Math.min(255, g));
                b = Math.max(0, Math.min(255, b));
                dest.setRGB(i, j, r, g, b);
            }
        }
        return dest;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }
}

