/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.DoubleRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Random.Random;

public class RandomConvolution
implements IApplyInPlace {
    private int size;
    private DoubleRange range;
    private double[][] kernel;
    private boolean replicate = false;
    private boolean genKernel = true;

    public double[][] getKernel() {
        return this.kernel;
    }

    public void setKernel(double[][] kernel) {
        this.kernel = kernel;
        this.genKernel = false;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public RandomConvolution() {
        this(3);
    }

    public RandomConvolution(int size) {
        this(size, new DoubleRange(-2.5, 2.5));
    }

    public RandomConvolution(int size, DoubleRange range) {
        this(size, range, true);
    }

    public RandomConvolution(int size, DoubleRange range, boolean replicate) {
        this.size = size;
        this.range = range;
        this.replicate = replicate;
        this.Generate();
    }

    public void Generate() {
        Random rand = new Random(System.currentTimeMillis());
        if (this.genKernel) {
            this.kernel = new double[this.size][this.size];
            for (int i = 0; i < this.kernel.length; ++i) {
                for (int j = 0; j < this.kernel[0].length; ++j) {
                    this.kernel[i][j] = rand.nextDouble(this.range.getMin(), this.range.getMax());
                }
            }
        }
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        int lines = this.CalcLines(this.kernel);
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    double gray = 0.0;
                    for (int i = 0; i < this.kernel.length; ++i) {
                        int Xline = x + (i - lines);
                        for (int j = 0; j < this.kernel[0].length; ++j) {
                            int Yline = y + (j - lines);
                            if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                                gray += this.kernel[i][j] * (double)copy.getGray(Xline, Yline);
                                continue;
                            }
                            if (!this.replicate) continue;
                            int r = x + i - lines;
                            int c = y + j - lines;
                            if (r < 0) {
                                r = 0;
                            }
                            if (r >= height) {
                                r = height - 1;
                            }
                            if (c < 0) {
                                c = 0;
                            }
                            if (c >= width) {
                                c = width - 1;
                            }
                            gray += this.kernel[i][j] * (double)copy.getGray(r, c);
                        }
                    }
                    gray = gray > 255.0 ? 255.0 : gray;
                    gray = gray < 0.0 ? 0.0 : gray;
                    fastBitmap.setGray(x, y, (int)gray);
                }
            }
        } else {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    double b = 0.0;
                    double g = 0.0;
                    double r = 0.0;
                    for (int i = 0; i < this.kernel.length; ++i) {
                        int Xline = x + (i - lines);
                        for (int j = 0; j < this.kernel[0].length; ++j) {
                            int Yline = y + (j - lines);
                            if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                                r += this.kernel[i][j] * (double)copy.getRed(Xline, Yline);
                                g += this.kernel[i][j] * (double)copy.getGreen(Xline, Yline);
                                b += this.kernel[i][j] * (double)copy.getBlue(Xline, Yline);
                                continue;
                            }
                            if (!this.replicate) continue;
                            int rr = x + i - lines;
                            int cc = y + j - lines;
                            if (rr < 0) {
                                rr = 0;
                            }
                            if (rr >= height) {
                                rr = height - 1;
                            }
                            if (cc < 0) {
                                cc = 0;
                            }
                            if (cc >= width) {
                                cc = width - 1;
                            }
                            r += this.kernel[i][j] * (double)copy.getRed(rr, cc);
                            g += this.kernel[i][j] * (double)copy.getGreen(rr, cc);
                            b += this.kernel[i][j] * (double)copy.getBlue(rr, cc);
                        }
                    }
                    r = r > 255.0 ? 255.0 : r;
                    g = g > 255.0 ? 255.0 : g;
                    b = b > 255.0 ? 255.0 : b;
                    r = r < 0.0 ? 0.0 : r;
                    g = g < 0.0 ? 0.0 : g;
                    b = b < 0.0 ? 0.0 : b;
                    fastBitmap.setRGB(x, y, (int)r, (int)g, (int)b);
                }
            }
        }
    }

    private int CalcLines(double[][] kernel) {
        int lines = (kernel[0].length - 1) / 2;
        return lines;
    }
}

