/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class GradientFaces
implements IPhotometricFilter {
    private double sigma;
    private double[][] gx;
    private double[][] gy;
    private boolean useEquation = true;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
        this.BuildDerivatives(sigma);
    }

    public boolean isUseEquation() {
        return this.useEquation;
    }

    public void setUseEquation(boolean useEquation) {
        this.useEquation = useEquation;
    }

    public GradientFaces() {
        this(0.75);
    }

    public GradientFaces(double sigma) {
        this(sigma, false);
    }

    public GradientFaces(double sigma, boolean useEquation) {
        this.setSigma(sigma);
        this.useEquation = useEquation;
    }

    private void BuildDerivatives(double sigma) {
        int j;
        int size = (int)Math.floor(3.5 * sigma);
        double[][] kernelX = new double[size * 2 + 1][size * 2 + 1];
        for (int i = 0; i < kernelX.length; ++i) {
            int n = -size;
            for (j = 0; j < kernelX[0].length; ++j) {
                kernelX[i][j] = n++;
            }
        }
        double[][] kernelY = Matrix.Transpose(kernelX);
        this.gx = new double[kernelX.length][kernelX[0].length];
        for (int i = 0; i < this.gx.length; ++i) {
            for (j = 0; j < this.gx[0].length; ++j) {
                this.gx[i][j] = -2.0 * kernelX[i][j] * Math.exp(-(kernelX[i][j] * kernelX[i][j] + kernelY[i][j] * kernelY[i][j]) / (2.0 * (sigma * sigma)));
            }
        }
        this.gy = Matrix.Transpose(this.gx);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double[][] response = new double[height][width];
        int lines = (this.gx.length - 1) / 2;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                double grayY = 0.0;
                double grayX = 0.0;
                for (i = 0; i < this.gx.length; ++i) {
                    int Xline = x + (i - lines);
                    for (j = 0; j < this.gx[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                            grayX += this.gx[i][j] * (double)fastBitmap.getGray(Xline, Yline);
                            grayY += this.gy[i][j] * (double)fastBitmap.getGray(Xline, Yline);
                            continue;
                        }
                        int r = x + i - lines;
                        int c = y + j - lines;
                        if (r < 0) {
                            r = 0;
                        }
                        if (r >= height) {
                            r = height - 1;
                        }
                        if (c < 0) {
                            c = 0;
                        }
                        if (c >= width) {
                            c = width - 1;
                        }
                        grayX += this.gx[i][j] * (double)fastBitmap.getGray(r, c);
                        grayY += this.gy[i][j] * (double)fastBitmap.getGray(r, c);
                    }
                }
                response[x][y] = Math.atan2(grayY, grayX);
                min = Math.min(min, response[x][y]);
                max = Math.max(max, response[x][y]);
            }
        }
        if (this.useEquation) {
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            double pi2 = Math.PI * 2;
            for (i = 0; i < response.length; ++i) {
                for (j = 0; j < response[0].length; ++j) {
                    if (response[i][j] >= 0.0) {
                        double[] dArray = response[i];
                        int n = j;
                        dArray[n] = dArray[n] + pi2;
                    } else {
                        response[i][j] = pi2 - response[i][j];
                    }
                    min = Math.min(min, response[i][j]);
                    max = Math.max(max, response[i][j]);
                }
            }
        }
        for (int i2 = 0; i2 < height; ++i2) {
            for (int j2 = 0; j2 < width; ++j2) {
                fastBitmap.setGray(i2, j2, (int)Tools.Scale(min, max, 0.0, 255.0, response[i2][j2]));
            }
        }
    }
}

