/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class Median
implements IApplyInPlace {
    private int radius = 1;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public Median() {
    }

    public Median(int radius) {
        this.radius = Math.max(1, radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block9: {
            FastBitmap copy;
            int maxArray;
            int lines;
            int height;
            int width;
            block8: {
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                lines = this.CalcLines(this.radius);
                maxArray = lines * lines;
                copy = new FastBitmap(fastBitmap);
                if (!fastBitmap.isGrayscale()) break block8;
                int[] avgL = new int[maxArray];
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - this.radius);
                                if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                avgL[c] = copy.getGray(Xline, Yline);
                                ++c;
                            }
                        }
                        Arrays.sort(avgL, 0, c);
                        int median = c / 2;
                        fastBitmap.setGray(x, y, avgL[median]);
                    }
                }
                break block9;
            }
            if (!fastBitmap.isRGB()) break block9;
            int[] avgR = new int[maxArray];
            int[] avgG = new int[maxArray];
            int[] avgB = new int[maxArray];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int c = 0;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            avgR[c] = copy.getRed(Xline, Yline);
                            avgG[c] = copy.getGreen(Xline, Yline);
                            avgB[c] = copy.getBlue(Xline, Yline);
                            ++c;
                        }
                    }
                    Arrays.sort(avgR, 0, c);
                    Arrays.sort(avgG, 0, c);
                    Arrays.sort(avgB, 0, c);
                    int median = c / 2;
                    fastBitmap.setRGB(x, y, avgR[median], avgG[median], avgB[median]);
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

