/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Mean
implements IApplyInPlace {
    private int radius = 1;
    private Arithmetic arithmetic = Arithmetic.Mean;
    private int order = 1;

    public Mean() {
    }

    public Mean(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    public Mean(Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public Mean(int radius, Arithmetic arithmetic) {
        this.radius = radius = radius < 1 ? 1 : radius;
        this.arithmetic = arithmetic;
    }

    public Arithmetic getArithmetic() {
        return this.arithmetic;
    }

    public void setArithmetic(Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int orderFilter) {
        this.order = orderFilter;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(this.radius);
        FastBitmap copy = new FastBitmap(fastBitmap);
        switch (this.arithmetic) {
            case Mean: {
                if (fastBitmap.isGrayscale()) {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            int sumGray = 0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumGray += copy.getGray(Xline, Yline);
                                    ++c;
                                }
                            }
                            fastBitmap.setGray(x, y, sumGray /= c);
                        }
                    }
                } else {
                    if (!fastBitmap.isRGB()) break;
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            int sumB = 0;
                            int sumG = 0;
                            int sumR = 0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumR += copy.getRed(Xline, Yline);
                                    sumG += copy.getGreen(Xline, Yline);
                                    sumB += copy.getBlue(Xline, Yline);
                                    ++c;
                                }
                            }
                            fastBitmap.setRGB(x, y, sumR /= c, sumG /= c, sumB /= c);
                        }
                    }
                }
                break;
            }
            case Harmonic: {
                if (fastBitmap.isGrayscale()) {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            double sumGray = 0.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumGray += 1.0 / (double)copy.getGray(Xline, Yline);
                                    ++c;
                                }
                            }
                            sumGray = (double)c / sumGray;
                            fastBitmap.setGray(x, y, (int)sumGray);
                        }
                    }
                } else {
                    if (!fastBitmap.isRGB()) break;
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            double sumB = 0.0;
                            double sumG = 0.0;
                            double sumR = 0.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumR += 1.0 / (double)copy.getRed(Xline, Yline);
                                    sumG += 1.0 / (double)copy.getGreen(Xline, Yline);
                                    sumB += 1.0 / (double)copy.getBlue(Xline, Yline);
                                    ++c;
                                }
                            }
                            sumR = (double)c / sumR;
                            sumG = (double)c / sumG;
                            sumB = (double)c / sumB;
                            fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                        }
                    }
                }
                break;
            }
            case ContraHarmonic: {
                if (fastBitmap.isGrayscale()) {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            double sumGrayTwo = 0.0;
                            double sumGrayOne = 0.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumGrayOne += Math.pow(copy.getGray(Xline, Yline), this.order + 1);
                                    sumGrayTwo += Math.pow(copy.getGray(Xline, Yline), this.order);
                                }
                            }
                            double sumGray = sumGrayOne / sumGrayTwo;
                            fastBitmap.setGray(x, y, (int)sumGray);
                        }
                    }
                } else {
                    if (!fastBitmap.isRGB()) break;
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            double sumBone = 0.0;
                            double sumGone = 0.0;
                            double sumRone = 0.0;
                            double sumBtwo = 0.0;
                            double sumGtwo = 0.0;
                            double sumRtwo = 0.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumRone += Math.pow(copy.getRed(Xline, Yline), this.order + 1);
                                    sumGone += Math.pow(copy.getGreen(Xline, Yline), this.order + 1);
                                    sumBone += Math.pow(copy.getBlue(Xline, Yline), this.order + 1);
                                    sumRtwo += Math.pow(copy.getRed(Xline, Yline), this.order);
                                    sumGtwo += Math.pow(copy.getGreen(Xline, Yline), this.order);
                                    sumBtwo += Math.pow(copy.getBlue(Xline, Yline), this.order);
                                }
                            }
                            double sumR = sumRone / sumRtwo;
                            double sumG = sumGone / sumGtwo;
                            double sumB = sumBone / sumBtwo;
                            fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                        }
                    }
                }
                break;
            }
            case Geometry: {
                if (fastBitmap.isGrayscale()) {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            double sumGray = 1.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumGray *= (double)copy.getGray(Xline, Yline);
                                    ++c;
                                }
                            }
                            sumGray = Math.pow(sumGray, 1.0 / (double)c);
                            fastBitmap.setGray(x, y, (int)sumGray);
                        }
                    }
                } else {
                    if (!fastBitmap.isRGB()) break;
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int c = 0;
                            double sumB = 1.0;
                            double sumG = 1.0;
                            double sumR = 1.0;
                            for (int i = 0; i < lines; ++i) {
                                int Xline = x + (i - this.radius);
                                for (int j = 0; j < lines; ++j) {
                                    int Yline = y + (j - this.radius);
                                    if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                    sumR *= (double)copy.getRed(Xline, Yline);
                                    sumG *= (double)copy.getGreen(Xline, Yline);
                                    sumB *= (double)copy.getBlue(Xline, Yline);
                                    ++c;
                                }
                            }
                            sumR = Math.pow(sumR, 1.0 / (double)c);
                            sumG = Math.pow(sumG, 1.0 / (double)c);
                            sumB = Math.pow(sumB, 1.0 / (double)c);
                            fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                        }
                    }
                }
                break;
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }

    public static enum Arithmetic {
        Mean,
        Harmonic,
        ContraHarmonic,
        Geometry;

    }
}

