/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class IsoDataClassifier
implements IApplyInPlace {
    int n;
    int[] histogram;

    public IsoDataClassifier() {
        this.n = 3;
    }

    public IsoDataClassifier(int n) {
        this.n = Math.min(255, n);
        this.n = Math.max(1, n);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.histogram = this.Histogram(fastBitmap);
            this.histogram = this.IsoData(this.histogram, this.n);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                fastBitmap.setGray(i, this.histogram[fastBitmap.getGray(i)]);
            }
        } else {
            throw new IllegalArgumentException("IsoData Classifier only works with grayscale image.");
        }
    }

    private int[] Histogram(FastBitmap fastBitmap) {
        int size = fastBitmap.getSize();
        int[] hist = new int[256];
        for (int i = 0; i < size; ++i) {
            int n = fastBitmap.getGray(i);
            hist[n] = hist[n] + 1;
        }
        return hist;
    }

    private int[] IsoData(int[] histogram, int classes) {
        int[] result = new int[histogram.length];
        int total = 0;
        for (int i = 0; i < histogram.length; ++i) {
            total += histogram[i] * i;
        }
        int left = 0;
        int i = 0;
        for (int j = 0; j < classes; ++j) {
            int v;
            int i2 = i;
            int previousLeft = left;
            int count = 0;
            while (i2 < histogram.length && left * classes / total < j + 1) {
                left += histogram[i2] * i2;
                count += histogram[i2++];
            }
            int n = v = count > 0 ? (left - previousLeft) / count : (i2 + i) / 2;
            while (i < i2) {
                result[i++] = v;
            }
        }
        return result;
    }
}

