/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;

public class ImagePyramids {
    private int level = 1;
    float[][] gaussianDownscale = new float[][]{{0.00390625f, 0.015625f, 0.0234375f, 0.015625f, 0.00390625f}, {0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f}, {0.0234375f, 0.09375f, 0.140625f, 0.09375f, 0.0234375f}, {0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f}, {0.00390625f, 0.015625f, 0.0234375f, 0.015625f, 0.00390625f}};
    float[][] gaussianUpscale = new float[][]{{0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f}, {0.0625f, 0.25f, 0.375f, 0.25f, 0.0625f}, {0.09375f, 0.375f, 0.5625f, 0.375f, 0.09375f}, {0.0625f, 0.25f, 0.375f, 0.25f, 0.0625f}, {0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f}};

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Math.max(1, level);
    }

    public ImagePyramids() {
    }

    public ImagePyramids(int level) {
        this.setLevel(level);
    }

    public void Downscale(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            for (int x = 0; x < this.level; ++x) {
                float[][] image = this.ConvolutionGray(fastBitmap, this.gaussianDownscale, true);
                int width = image[0].length;
                int height = image.length;
                FastBitmap copy = new FastBitmap(width / 2, height / 2, FastBitmap.ColorSpace.Grayscale);
                for (int i = 0; i < height - 1; i += 2) {
                    for (int j = 0; j < width - 1; j += 2) {
                        copy.setGray(i / 2, j / 2, (int)(image[i][j] * 255.0f));
                    }
                }
                fastBitmap.setImage(copy);
            }
        } else {
            for (int x = 0; x < this.level; ++x) {
                float[][][] image = this.ConvolutionRGB(fastBitmap, this.gaussianDownscale);
                int width = image[0].length;
                int height = image.length;
                FastBitmap copy = new FastBitmap(width / 2, height / 2);
                for (int i = 0; i < height - 1; i += 2) {
                    for (int j = 0; j < width - 1; j += 2) {
                        copy.setRGB(i / 2, j / 2, (int)(image[i][j][0] * 255.0f), (int)(image[i][j][1] * 255.0f), (int)(image[i][j][2] * 255.0f));
                    }
                }
                fastBitmap.setImage(copy);
            }
        }
    }

    private float[][] ConvolutionGray(FastBitmap fastBitmap, float[][] kernel, boolean replicate) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        float[][] image = new float[height][width];
        int lines = (kernel[0].length - 1) / 2;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                float gray = 0.0f;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = r + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = c + (j - lines);
                        if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                            gray += kernel[i][j] * ((float)fastBitmap.getGray(Xline, Yline) / 255.0f);
                            continue;
                        }
                        if (!replicate) continue;
                        int R = r + i - 1;
                        int C = c + j - 1;
                        if (R < 0) {
                            R = 0;
                        }
                        if (R >= height) {
                            R = height - 1;
                        }
                        if (C < 0) {
                            C = 0;
                        }
                        if (C >= width) {
                            C = width - 1;
                        }
                        int val = fastBitmap.getGray(R, C);
                        gray += kernel[i][j] * ((float)fastBitmap.getGray(R, C) / 255.0f);
                    }
                }
                gray = gray > 1.0f ? 1.0f : gray;
                image[r][c] = gray = gray < 0.0f ? 0.0f : gray;
            }
        }
        return image;
    }

    private float[][][] ConvolutionRGB(FastBitmap fastBitmap, float[][] kernel) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        float[][][] image = new float[height][width][3];
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                float blue = 0.0f;
                float green = 0.0f;
                float red = 0.0f;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = r + (i - 2);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = c + (j - 2);
                        if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                            red += kernel[i][j] * (float)fastBitmap.getRed(Xline, Yline) / 255.0f;
                            green += kernel[i][j] * (float)fastBitmap.getGreen(Xline, Yline) / 255.0f;
                            blue += kernel[i][j] * (float)fastBitmap.getBlue(Xline, Yline) / 255.0f;
                            continue;
                        }
                        red += kernel[i][j] * (float)fastBitmap.getRed(r, c) / 255.0f;
                        green += kernel[i][j] * (float)fastBitmap.getGreen(r, c) / 255.0f;
                        blue += kernel[i][j] * (float)fastBitmap.getBlue(r, c) / 255.0f;
                    }
                }
                red = red > 1.0f ? 1.0f : red;
                red = red < 0.0f ? 0.0f : red;
                green = green > 1.0f ? 1.0f : green;
                green = green < 0.0f ? 0.0f : green;
                blue = blue > 1.0f ? 1.0f : blue;
                blue = blue < 0.0f ? 0.0f : blue;
                image[r][c][0] = red;
                image[r][c][1] = green;
                image[r][c][2] = blue;
            }
        }
        return image;
    }
}

