/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;

public class ImageNormalization
implements IApplyInPlace {
    private float mean = 160.0f;
    private float variance = 150.0f;

    public float getMean() {
        return this.mean;
    }

    public void setMean(float mean) {
        this.mean = Math.max(0.0f, Math.min(255.0f, mean));
    }

    public float getVariance() {
        return this.variance;
    }

    public void setVariance(float variance) {
        this.variance = Math.max(0.0f, Math.min(255.0f, variance));
    }

    public ImageNormalization() {
    }

    public ImageNormalization(float mean, float variance) {
        this.setMean(mean);
        this.setVariance(variance);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            float globalMean = ImageStatistics.Mean(fastBitmap);
            float globalVariance = ImageStatistics.Variance(fastBitmap, globalMean);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                float common = (float)Math.sqrt(this.variance * (float)Math.pow((float)g - globalMean, 2.0) / globalVariance);
                int n = 0;
                n = (float)g > globalMean ? (int)(this.mean + common) : (int)(this.mean - common);
                n = n > 255 ? 255 : n;
                n = n < 0 ? 0 : n;
                fastBitmap.setGray(i, n);
            }
        } else {
            throw new IllegalArgumentException("ImageNormalization only works with grayscale images.");
        }
    }
}

