/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class HueModifier
implements IApplyInPlace {
    private float degree;

    public float getDegree() {
        return this.degree;
    }

    public void setDegree(float degree) {
        this.degree = degree;
    }

    public HueModifier(float degree) {
        this.degree = degree;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getWidth() * fastBitmap.getHeight();
            for (int i = 0; i < size; ++i) {
                int b;
                int g;
                int r = fastBitmap.getRed(i);
                double[] color = ColorConverter.RGBtoHSL(r, g = fastBitmap.getGreen(i), b = fastBitmap.getBlue(i));
                int[] newColor = ColorConverter.HSLtoRGB(this.degree, color[1], color[2]);
                newColor[0] = newColor[0] > 255 ? 255 : newColor[0];
                newColor[0] = newColor[0] < 0 ? 0 : newColor[0];
                newColor[1] = newColor[1] > 255 ? 255 : newColor[1];
                newColor[1] = newColor[1] < 0 ? 0 : newColor[1];
                newColor[2] = newColor[2] > 255 ? 255 : newColor[2];
                newColor[2] = newColor[2] < 0 ? 0 : newColor[2];
                fastBitmap.setRGB(i, newColor);
            }
        } else {
            throw new IllegalArgumentException("Hue modifier only works in RGB images.");
        }
    }
}

