/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.List;

public class HitAndMiss
implements IApplyInPlace {
    private int[][] kernel;
    private List<int[][]> kernels;
    private Mode mode;
    private Logic logic;

    public HitAndMiss(int[][] kernel) {
        this(kernel, Mode.HitAndMiss);
    }

    public HitAndMiss(int[][] kernel, Mode mode) {
        this.kernel = kernel;
        this.mode = mode;
    }

    public HitAndMiss(List<int[][]> kernels, Logic logic) {
        this.kernels = kernels;
        this.logic = logic;
    }

    public HitAndMiss(List<int[][]> kernels, Logic logic, Mode mode) {
        this.kernels = kernels;
        this.logic = logic;
        this.mode = mode;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("The image must be in grayscale.");
        }
        if (this.kernels != null) {
            this.apply(fastBitmap, this.kernels);
        }
        FastBitmap copy = new FastBitmap(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int p = this.mode == Mode.HitAndMiss ? 255 : 0;
        int lines = this.CalcLines(this.kernel);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int l = copy.getGray(x, y);
                if (l != 255) continue;
                int hits = 0;
                for (int i = 0; i < this.kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < this.kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        if (this.kernel[i][j] >= 0) {
                            if (this.kernel[i][j] == 1 && copy.getGray(Xline, Yline) == 255) {
                                ++hits;
                            }
                            if (this.kernel[i][j] != 0 || copy.getGray(Xline, Yline) != 0) continue;
                            ++hits;
                            continue;
                        }
                        ++hits;
                    }
                }
                if (hits != 9) continue;
                fastBitmap.setGray(x, y, p);
            }
        }
    }

    private void apply(FastBitmap fastBitmap, List<int[][]> kernels) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("The image must be in grayscale.");
        }
        FastBitmap copy = new FastBitmap(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int p = this.mode == Mode.HitAndMiss ? 255 : 0;
        int pMatches = this.logic == Logic.And ? 9 * kernels.size() : 9;
        int lines = this.CalcLines(this.kernel);
        for (int x = 0; x < height; ++x) {
            block1: for (int y = 0; y < width; ++y) {
                int l = copy.getGray(x, y);
                if (l != 255) continue;
                for (int[][] se : kernels) {
                    int hits = 0;
                    for (int i = 0; i < se.length; ++i) {
                        int Xline = x + (i - lines);
                        for (int j = 0; j < se[0].length; ++j) {
                            int Yline = y + (j - lines);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            if (se[i][j] >= 0) {
                                if (se[i][j] == 1 && copy.getGray(Xline, Yline) == 255) {
                                    ++hits;
                                }
                                if (se[i][j] != 0 || copy.getGray(Xline, Yline) != 0) continue;
                                ++hits;
                                continue;
                            }
                            ++hits;
                        }
                    }
                    if (hits != pMatches) continue;
                    fastBitmap.setGray(x, y, p);
                    continue block1;
                }
            }
        }
    }

    private int CalcLines(int[][] se) {
        int lines = (se[0].length - 1) / 2;
        return lines;
    }

    public static enum Logic {
        And,
        Or;

    }

    public static enum Mode {
        HitAndMiss,
        Thinning;

    }
}

