/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;
import java.util.ArrayList;

public class HistogramEqualization
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block3: {
            ArrayList<int[]> histLUT;
            block2: {
                histLUT = this.histogramEqualizationLUT(fastBitmap);
                if (!fastBitmap.isGrayscale()) break block2;
                int size = fastBitmap.getSize();
                for (int i = 0; i < size; ++i) {
                    int gray = fastBitmap.getGray(i);
                    gray = histLUT.get(0)[gray];
                    fastBitmap.setGray(i, gray);
                }
                break block3;
            }
            if (!fastBitmap.isRGB()) break block3;
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int red = fastBitmap.getRed(i);
                int green = fastBitmap.getGreen(i);
                int blue = fastBitmap.getBlue(i);
                red = histLUT.get(0)[red];
                green = histLUT.get(1)[green];
                blue = histLUT.get(2)[blue];
                fastBitmap.setRGB(i, red, green, blue);
            }
        }
    }

    private ArrayList<int[]> histogramEqualizationLUT(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        ArrayList<int[]> imageHist = new ArrayList<int[]>();
        float scale_factor = (float)(255.0 / (double)(fastBitmap.getWidth() * fastBitmap.getHeight()));
        if (fastBitmap.isGrayscale()) {
            imageHist.add(stat.getHistogramGray().getValues());
            ArrayList<int[]> imageLUT = new ArrayList<int[]>();
            int[] grayhistogram = new int[256];
            for (int i = 0; i < 256; ++i) {
                grayhistogram[i] = 0;
            }
            long sumgray = 0L;
            for (int i = 0; i < 256; ++i) {
                int valgray = (int)((float)(sumgray += (long)((int[])imageHist.get(0))[i]) * scale_factor);
                grayhistogram[i] = valgray > 255 ? 255 : valgray;
            }
            imageLUT.add(grayhistogram);
            return imageLUT;
        }
        imageHist.add(stat.getHistogramRed().getValues());
        imageHist.add(stat.getHistogramGreen().getValues());
        imageHist.add(stat.getHistogramBlue().getValues());
        ArrayList<int[]> imageLUT = new ArrayList<int[]>();
        int[] rhistogram = new int[256];
        int[] ghistogram = new int[256];
        int[] bhistogram = new int[256];
        for (int i = 0; i < 256; ++i) {
            rhistogram[i] = 0;
            ghistogram[i] = 0;
            bhistogram[i] = 0;
        }
        long sumr = 0L;
        long sumg = 0L;
        long sumb = 0L;
        for (int i = 0; i < 256; ++i) {
            int valr = (int)((float)(sumr += (long)((int[])imageHist.get(0))[i]) * scale_factor);
            rhistogram[i] = valr > 255 ? 255 : valr;
            int valg = (int)((float)(sumg += (long)((int[])imageHist.get(1))[i]) * scale_factor);
            ghistogram[i] = valg > 255 ? 255 : valg;
            int valb = (int)((float)(sumb += (long)((int[])imageHist.get(2))[i]) * scale_factor);
            bhistogram[i] = valb > 255 ? 255 : valb;
        }
        imageLUT.add(rhistogram);
        imageLUT.add(ghistogram);
        imageLUT.add(bhistogram);
        return imageLUT;
    }
}

