/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.FloatRange;
import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class HSLFiltering
implements IApplyInPlace {
    private IntRange hue = new IntRange(0, 359);
    private FloatRange saturation = new FloatRange(0.0f, 1.0f);
    private FloatRange luminance = new FloatRange(0.0f, 1.0f);
    private int fillH = 0;
    private float fillS = 0.0f;
    private float fillL = 0.0f;
    private boolean fillOutsideRange = true;
    private boolean updateH = true;
    private boolean updateS = true;
    private boolean updateL = true;

    public IntRange getHue() {
        return this.hue;
    }

    public void setHue(IntRange hue) {
        this.hue = hue;
    }

    public FloatRange getSaturation() {
        return this.saturation;
    }

    public void setSaturation(FloatRange saturation) {
        this.saturation = saturation;
    }

    public FloatRange getLuminance() {
        return this.luminance;
    }

    public void setLuminance(FloatRange luminance) {
        this.luminance = luminance;
    }

    public float[] getFillColor() {
        return new float[]{this.fillH, this.fillS, this.fillL};
    }

    public void setFillColor(int hue, float saturation, float luminance) {
        this.fillH = hue;
        this.fillS = saturation;
        this.fillL = luminance;
    }

    public boolean isFillOutsideRange() {
        return this.fillOutsideRange;
    }

    public void setFillOutsideRange(boolean fillOutsideRange) {
        this.fillOutsideRange = fillOutsideRange;
    }

    public boolean isUpdatedHue() {
        return this.updateH;
    }

    public void setUpdateHue(boolean update) {
        this.updateH = update;
    }

    public boolean isUpdatedSaturation() {
        return this.updateS;
    }

    public void setUpdateSaturation(boolean update) {
        this.updateS = update;
    }

    public boolean isUpdatedLuminance() {
        return this.updateL;
    }

    public void setUpdateLuminance(boolean update) {
        this.updateL = update;
    }

    public HSLFiltering() {
    }

    public HSLFiltering(IntRange hue, FloatRange saturation, FloatRange luminance) {
        this.hue = hue;
        this.saturation = saturation;
        this.luminance = luminance;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int b;
                int g;
                boolean updated = false;
                int r = fastBitmap.getRed(i);
                double[] hsl = ColorConverter.RGBtoHSL(r, g = fastBitmap.getGreen(i), b = fastBitmap.getBlue(i));
                if (hsl[1] >= (double)this.saturation.getMin() && hsl[1] <= (double)this.saturation.getMax() && hsl[2] >= (double)this.luminance.getMin() && hsl[2] <= (double)this.luminance.getMax() && (this.hue.getMin() < this.hue.getMax() && hsl[0] >= (double)this.hue.getMin() && hsl[0] <= (double)this.hue.getMax() || this.hue.getMin() > this.hue.getMax() && (hsl[0] >= (double)this.hue.getMin() || hsl[0] <= (double)this.hue.getMax()))) {
                    if (!this.fillOutsideRange) {
                        if (this.updateH) {
                            hsl[0] = this.fillH;
                        }
                        if (this.updateS) {
                            hsl[1] = this.fillS;
                        }
                        if (this.updateL) {
                            hsl[2] = this.fillL;
                        }
                        updated = true;
                    }
                } else if (this.fillOutsideRange) {
                    if (this.updateH) {
                        hsl[0] = this.fillH;
                    }
                    if (this.updateS) {
                        hsl[1] = this.fillS;
                    }
                    if (this.updateL) {
                        hsl[2] = this.fillL;
                    }
                    updated = true;
                }
                if (!updated) continue;
                int[] rgb = ColorConverter.HSLtoRGB(hsl[0], hsl[1], hsl[2]);
                fastBitmap.setRGB(i, rgb);
            }
        } else {
            throw new IllegalArgumentException("HSL Filtering only works in RGB images.");
        }
    }
}

