/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Grayscale
implements IApplyInPlace {
    double redCoefficient = 0.2125;
    double greenCoefficient = 0.7154;
    double blueCoefficient = 0.0721;
    private Algorithm grayscaleMethod;
    private boolean isAlgorithm = false;

    public Grayscale() {
    }

    public Grayscale(double redCoefficient, double greenCoefficient, double blueCoefficient) {
        this.redCoefficient = redCoefficient;
        this.greenCoefficient = greenCoefficient;
        this.blueCoefficient = blueCoefficient;
        this.isAlgorithm = false;
    }

    public Grayscale(Algorithm grayscaleMethod) {
        this.grayscaleMethod = grayscaleMethod;
        this.isAlgorithm = true;
    }

    public double getRedCoefficient() {
        return this.redCoefficient;
    }

    public void setRedCoefficient(double redCoefficient) {
        this.redCoefficient = redCoefficient;
    }

    public double getGreenCoefficient() {
        return this.greenCoefficient;
    }

    public void setGreenCoefficient(double greenCoefficient) {
        this.greenCoefficient = greenCoefficient;
    }

    public double getBlueCoefficient() {
        return this.blueCoefficient;
    }

    public void setBlueCoefficient(double blueCoefficient) {
        this.blueCoefficient = blueCoefficient;
    }

    public Algorithm getGrayscaleMethod() {
        return this.grayscaleMethod;
    }

    public void setGrayscaleMethod(Algorithm grayscaleMethod) {
        this.grayscaleMethod = grayscaleMethod;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!this.isAlgorithm) {
            FastBitmap fb = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight(), FastBitmap.ColorSpace.Grayscale);
            int[] pixelsRGB = fastBitmap.getRGBData();
            byte[] pixelsG = fb.getGrayData();
            for (int i = 0; i < pixelsG.length; ++i) {
                double r = pixelsRGB[i] >> 16 & 0xFF;
                double g = pixelsRGB[i] >> 8 & 0xFF;
                double b = pixelsRGB[i] & 0xFF;
                double gray = r * this.redCoefficient + g * this.greenCoefficient + b * this.blueCoefficient;
                pixelsG[i] = (byte)gray;
            }
            fb.setGrayData(pixelsG);
            fastBitmap.setImage(fb);
        } else {
            this.Apply(fastBitmap, this.grayscaleMethod);
        }
    }

    private void Apply(FastBitmap fastBitmap, Algorithm grayMethod) {
        FastBitmap fb = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight(), FastBitmap.ColorSpace.Grayscale);
        int[] pixelsRGB = fastBitmap.getRGBData();
        byte[] pixelsG = fb.getGrayData();
        switch (grayMethod) {
            case Lightness: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double r = pixelsRGB[i] >> 16 & 0xFF;
                    double g = pixelsRGB[i] >> 8 & 0xFF;
                    double b = pixelsRGB[i] & 0xFF;
                    double max = Math.max(r, g);
                    max = Math.max(max, b);
                    double min = Math.min(r, g);
                    min = Math.min(min, b);
                    double gray = (max + min) / 2.0;
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
            case Average: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double r = pixelsRGB[i] >> 16 & 0xFF;
                    double g = pixelsRGB[i] >> 8 & 0xFF;
                    double b = pixelsRGB[i] & 0xFF;
                    double gray = (r + g + b) / 3.0;
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
            case GeometricMean: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double r = pixelsRGB[i] >> 16 & 0xFF;
                    double g = pixelsRGB[i] >> 8 & 0xFF;
                    double b = pixelsRGB[i] & 0xFF;
                    double gray = Math.pow(r * g * b, 0.33);
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
            case Luminosity: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double r = pixelsRGB[i] >> 16 & 0xFF;
                    double g = pixelsRGB[i] >> 8 & 0xFF;
                    double b = pixelsRGB[i] & 0xFF;
                    double gray = r * 0.2125 + g * 0.7154 + b * 0.0721;
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
            case MinimumDecomposition: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double gray = Math.min(pixelsRGB[i] >> 16 & 0xFF, pixelsRGB[i] >> 8 & 0xFF);
                    gray = Math.min(gray, (double)(pixelsRGB[i] & 0xFF));
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
            case MaximumDecomposition: {
                for (int i = 0; i < pixelsG.length; ++i) {
                    double gray = Math.max(pixelsRGB[i] >> 16 & 0xFF, pixelsRGB[i] >> 8 & 0xFF);
                    gray = Math.max(gray, (double)(pixelsRGB[i] & 0xFF));
                    pixelsG[i] = (byte)gray;
                }
                break;
            }
        }
        fastBitmap.setImage(fb);
    }

    public static enum Algorithm {
        Lightness,
        Average,
        GeometricMean,
        Luminosity,
        MinimumDecomposition,
        MaximumDecomposition;

    }
}

