/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class GaussianBoxBlur
implements IApplyInPlace {
    private double std;
    private int r;

    public int getRadius() {
        return this.r;
    }

    public void setRadius(int radius) {
        this.r = Math.max(1, radius);
    }

    public GaussianBoxBlur() {
        this(1.0);
    }

    public GaussianBoxBlur(double standardDeviation) {
        this(standardDeviation, 3);
    }

    public GaussianBoxBlur(double standartDeviation, int radius) {
        this.std = standartDeviation;
        this.r = radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap copy = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight(), fastBitmap.getColorSpace());
        int[] boxs = this.BoxesForGauss(this.std, this.r);
        if (fastBitmap.isGrayscale()) {
            this.BoxBlurGray(fastBitmap, copy, (boxs[0] - 1) / 2);
            this.BoxBlurGray(copy, fastBitmap, (boxs[1] - 1) / 2);
            this.BoxBlurGray(fastBitmap, copy, (boxs[2] - 1) / 2);
        } else if (fastBitmap.isRGB()) {
            this.BoxBlurRGB(fastBitmap, copy, (boxs[0] - 1) / 2);
            this.BoxBlurRGB(copy, fastBitmap, (boxs[1] - 1) / 2);
            this.BoxBlurRGB(fastBitmap, copy, (boxs[2] - 1) / 2);
        }
    }

    private void BoxBlurGray(FastBitmap source, FastBitmap dest, int r) {
        int size = source.getSize();
        for (int i = 0; i < size; ++i) {
            dest.setGray(i, source.getGray(i));
        }
        this.BoxBlurH_Gray(dest, source, r);
        this.BoxBlurT_Gray(source, dest, r);
    }

    private void BoxBlurRGB(FastBitmap source, FastBitmap dest, int r) {
        int size = source.getSize();
        for (int i = 0; i < size; ++i) {
            dest.setRGB(i, source.getRGB(i));
        }
        this.BoxBlurH_RGB(dest, source, r);
        this.BoxBlurT_RGB(source, dest, r);
    }

    private void BoxBlurH_Gray(FastBitmap source, FastBitmap dest, int r) {
        int w = source.getWidth();
        int h = source.getHeight();
        double iarr = 1.0 / (double)(r + r + 1);
        for (int i = 0; i < h; ++i) {
            int j;
            int ti;
            int li = ti = i * w;
            int ri = ti + r;
            int fv = source.getGray(ti);
            int lv = source.getGray(ti + w - 1);
            int val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += source.getGray(ti + j);
            }
            for (j = 0; j <= r; ++j) {
                dest.setGray(ti++, (int)Math.round((double)(val += source.getGray(ri++) - fv) * iarr));
            }
            for (j = r + 1; j < w - r; ++j) {
                dest.setGray(ti++, (int)Math.round((double)(val += source.getGray(ri++) - source.getGray(li++)) * iarr));
            }
            for (j = w - r; j < w; ++j) {
                dest.setGray(ti++, (int)Math.round((double)(val += lv - source.getGray(li++)) * iarr));
            }
        }
    }

    private void BoxBlurH_RGB(FastBitmap source, FastBitmap dest, int r) {
        int j;
        int val;
        int lv;
        int fv;
        int ri;
        int li;
        int ti;
        int i;
        int w = source.getWidth();
        int h = source.getHeight();
        double iarr = 1.0 / (double)(r + r + 1);
        for (i = 0; i < h; ++i) {
            li = ti = i * w;
            ri = ti + r;
            fv = source.getRed(ti);
            lv = source.getRed(ti + w - 1);
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += source.getRed(ti + j);
            }
            for (j = 0; j <= r; ++j) {
                dest.setRed(ti++, (int)Math.round((double)(val += source.getRed(ri++) - fv) * iarr));
            }
            for (j = r + 1; j < w - r; ++j) {
                dest.setRed(ti++, (int)Math.round((double)(val += source.getRed(ri++) - source.getRed(li++)) * iarr));
            }
            for (j = w - r; j < w; ++j) {
                dest.setRed(ti++, (int)Math.round((double)(val += lv - source.getRed(li++)) * iarr));
            }
        }
        for (i = 0; i < h; ++i) {
            li = ti = i * w;
            ri = ti + r;
            fv = source.getGreen(ti);
            lv = source.getGreen(ti + w - 1);
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += source.getGreen(ti + j);
            }
            for (j = 0; j <= r; ++j) {
                dest.setGreen(ti++, (int)Math.round((double)(val += source.getGreen(ri++) - fv) * iarr));
            }
            for (j = r + 1; j < w - r; ++j) {
                dest.setGreen(ti++, (int)Math.round((double)(val += source.getGreen(ri++) - source.getGreen(li++)) * iarr));
            }
            for (j = w - r; j < w; ++j) {
                dest.setGreen(ti++, (int)Math.round((double)(val += lv - source.getGreen(li++)) * iarr));
            }
        }
        for (i = 0; i < h; ++i) {
            li = ti = i * w;
            ri = ti + r;
            fv = source.getBlue(ti);
            lv = source.getBlue(ti + w - 1);
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += source.getBlue(ti + j);
            }
            for (j = 0; j <= r; ++j) {
                dest.setBlue(ti++, (int)Math.round((double)(val += source.getBlue(ri++) - fv) * iarr));
            }
            for (j = r + 1; j < w - r; ++j) {
                dest.setBlue(ti++, (int)Math.round((double)(val += source.getBlue(ri++) - source.getBlue(li++)) * iarr));
            }
            for (j = w - r; j < w; ++j) {
                dest.setBlue(ti++, (int)Math.round((double)(val += lv - source.getBlue(li++)) * iarr));
            }
        }
    }

    private void BoxBlurT_Gray(FastBitmap copy, FastBitmap original, int r) {
        int w = original.getWidth();
        int h = original.getHeight();
        double iarr = 1.0 / (double)(r + r + 1);
        for (int i = 0; i < w; ++i) {
            int j;
            int ti;
            int li = ti = i;
            int ri = ti + r * w;
            int fv = copy.getGray(ti);
            int lv = copy.getGray(ti + w * (h - 1));
            int val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += copy.getGray(ti + j * w);
            }
            for (j = 0; j <= r; ++j) {
                original.setGray(ti, (int)Math.round((double)(val += copy.getGray(ri) - fv) * iarr));
                ri += w;
                ti += w;
            }
            for (j = r + 1; j < h - r; ++j) {
                original.setGray(ti, (int)Math.round((double)(val += copy.getGray(ri) - copy.getGray(li)) * iarr));
                li += w;
                ri += w;
                ti += w;
            }
            for (j = h - r; j < h; ++j) {
                original.setGray(ti, (int)Math.round((double)(val += lv - copy.getGray(li)) * iarr));
                li += w;
                ti += w;
            }
        }
    }

    private void BoxBlurT_RGB(FastBitmap copy, FastBitmap original, int r) {
        int j;
        int val;
        int lv;
        int fv;
        int ri;
        int li;
        int ti;
        int i;
        int w = original.getWidth();
        int h = original.getHeight();
        double iarr = 1.0 / (double)(r + r + 1);
        for (i = 0; i < w; ++i) {
            li = ti = i;
            ri = ti + r * w;
            fv = copy.getRed(ti);
            lv = copy.getRed(ti + w * (h - 1));
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += copy.getRed(ti + j * w);
            }
            for (j = 0; j <= r; ++j) {
                original.setRed(ti, (int)Math.round((double)(val += copy.getRed(ri) - fv) * iarr));
                ri += w;
                ti += w;
            }
            for (j = r + 1; j < h - r; ++j) {
                original.setRed(ti, (int)Math.round((double)(val += copy.getRed(ri) - copy.getRed(li)) * iarr));
                li += w;
                ri += w;
                ti += w;
            }
            for (j = h - r; j < h; ++j) {
                original.setRed(ti, (int)Math.round((double)(val += lv - copy.getRed(li)) * iarr));
                li += w;
                ti += w;
            }
        }
        for (i = 0; i < w; ++i) {
            li = ti = i;
            ri = ti + r * w;
            fv = copy.getGreen(ti);
            lv = copy.getGreen(ti + w * (h - 1));
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += copy.getGreen(ti + j * w);
            }
            for (j = 0; j <= r; ++j) {
                original.setGreen(ti, (int)Math.round((double)(val += copy.getGreen(ri) - fv) * iarr));
                ri += w;
                ti += w;
            }
            for (j = r + 1; j < h - r; ++j) {
                original.setGreen(ti, (int)Math.round((double)(val += copy.getGreen(ri) - copy.getGreen(li)) * iarr));
                li += w;
                ri += w;
                ti += w;
            }
            for (j = h - r; j < h; ++j) {
                original.setGreen(ti, (int)Math.round((double)(val += lv - copy.getGreen(li)) * iarr));
                li += w;
                ti += w;
            }
        }
        for (i = 0; i < w; ++i) {
            li = ti = i;
            ri = ti + r * w;
            fv = copy.getBlue(ti);
            lv = copy.getBlue(ti + w * (h - 1));
            val = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                val += copy.getBlue(ti + j * w);
            }
            for (j = 0; j <= r; ++j) {
                original.setBlue(ti, (int)Math.round((double)(val += copy.getBlue(ri) - fv) * iarr));
                ri += w;
                ti += w;
            }
            for (j = r + 1; j < h - r; ++j) {
                original.setBlue(ti, (int)Math.round((double)(val += copy.getBlue(ri) - copy.getBlue(li)) * iarr));
                li += w;
                ri += w;
                ti += w;
            }
            for (j = h - r; j < h; ++j) {
                original.setBlue(ti, (int)Math.round((double)(val += lv - copy.getBlue(li)) * iarr));
                li += w;
                ti += w;
            }
        }
    }

    private int[] BoxesForGauss(double sigma, int n) {
        double wIdeal = Math.sqrt(12.0 * sigma * sigma / (double)n + 1.0);
        double wl = Math.floor(wIdeal);
        if (wl % 2.0 == 0.0) {
            wl -= 1.0;
        }
        double wu = wl + 2.0;
        double mIdeal = (12.0 * sigma * sigma - (double)n * wl * wl - (double)(4 * n) * wl - (double)(3 * n)) / (-4.0 * wl - 4.0);
        double m = Math.round(mIdeal);
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = (double)i < m ? (int)wl : (int)wu;
        }
        return sizes;
    }
}

