/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Functions.Gaussian;

public class GaussianBlur
implements IApplyInPlace {
    private double sigma = 1.4;
    private int size = 5;

    public GaussianBlur() {
    }

    public GaussianBlur(double sigma) {
        this.sigma = Math.max(0.5, Math.min(5.0, sigma));
    }

    public GaussianBlur(double sigma, int size) {
        this.setSigma(sigma);
        this.setSize(size);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = Math.max(0.5, Math.min(5.0, sigma));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = Math.max(3, Math.min(21, size | 1));
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int[][] k = this.CreateKernel();
        Convolution c = new Convolution(k, true);
        c.applyInPlace(fastBitmap);
    }

    private int[][] CreateKernel() {
        Gaussian g = new Gaussian(this.sigma);
        double[][] k = g.Kernel2D(this.size);
        int[][] kint = new int[k.length][k[0].length];
        double min = k[0][0];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                double v = k[i][j] / min;
                kint[i][j] = (int)v;
            }
        }
        return kint;
    }
}

